/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.WebElementIsDisabled;
import io.perfeccionista.framework.exceptions.WebElementIsEnabled;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebIsEnabledAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsEnabledAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldBeEnabledMatcher
implements WebIsEnabledAvailableMatcher {
    private final boolean positive;

    public WebShouldBeEnabledMatcher(boolean positive) {
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebIsEnabledAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldBeEnabled", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ShouldBeDisabled", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            boolean enabled = element.isEnabled();
            if (this.positive) {
                this.shouldBeEnabled(element, enabled);
            } else {
                this.shouldBeDisabled(element, enabled);
            }
        });
    }

    protected void shouldBeEnabled(WebIsEnabledAvailable element, boolean enabled) {
        if (!enabled) {
            throw WebElementIsDisabled.assertionError(PageFactoryWebApiMessages.ELEMENT_IS_DISABLED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        }
    }

    protected void shouldBeDisabled(WebIsEnabledAvailable element, boolean enabled) {
        if (enabled) {
            throw WebElementIsEnabled.assertionError(PageFactoryWebApiMessages.ELEMENT_IS_ENABLED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        }
    }
}

