/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.ElementIsDisplayed;
import io.perfeccionista.framework.exceptions.ElementNotDisplayed;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.HtmlAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebIsDisplayedAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsDisplayedOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import org.jetbrains.annotations.NotNull;

public class WebShouldBeDisplayedMatcher
implements WebIsDisplayedAvailableMatcher {
    private final boolean positive;

    public WebShouldBeDisplayedMatcher(boolean positive) {
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebChildElement element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldBeDisplayed", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ShouldNotBeDisplayed", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            if (this.positive) {
                this.shouldBeDisplayed(element);
            } else {
                this.shouldNotBeDisplayed(element);
            }
        });
    }

    protected void shouldBeDisplayed(WebChildElement element) {
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(element, operationType, "DISPLAYED").getOperation().withPageSource();
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (exception instanceof JsElementSearch) {
                throw ElementNotDisplayed.assertionError((String)PageFactoryApiMessages.ELEMENT_NOT_DISPLAYED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addSuppressedException((Throwable)exception).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
            throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        });
        boolean displayed = operationResult.getResult();
        if (!displayed) {
            throw ElementNotDisplayed.assertionError((String)PageFactoryApiMessages.ELEMENT_NOT_DISPLAYED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
        }
    }

    protected void shouldNotBeDisplayed(WebChildElement element) {
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(element, operationType, "DISPLAYED").getOperation().withPageSource();
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifSuccess(successOperationResult -> {
            boolean displayed = (Boolean)successOperationResult.getResult();
            if (displayed) {
                throw ElementIsDisplayed.assertionError((String)PageFactoryApiMessages.ELEMENT_IS_DISPLAYED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)HtmlAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
        });
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (!(exception instanceof JsElementSearch)) {
                throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
            }
        });
    }
}

