/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.ElementIsPresent;
import io.perfeccionista.framework.exceptions.ElementNotPresent;
import io.perfeccionista.framework.exceptions.attachments.Attachment;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.HtmlAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebComponentAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsPresentOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import org.jetbrains.annotations.NotNull;

public class WebComponentShouldBePresentMatcher
implements WebComponentAvailableMatcher {
    private final String componentName;
    private final boolean positive;

    public WebComponentShouldBePresentMatcher(@NotNull String componentName, boolean positive) {
        this.componentName = componentName;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebChildElement element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ComponentShouldBePresentMethod", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ComponentShouldNotBePresentMethod", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            if (this.positive) {
                this.shouldBePresent(element, this.componentName);
            } else {
                this.shouldNotBePresent(element, this.componentName);
            }
        });
    }

    protected void shouldBePresent(WebChildElement element, String componentName) {
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementIsPresentOperationHandler.of(element, operationType, componentName).getOperation().withPageSource();
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (exception instanceof JsElementSearch) {
                throw ElementNotPresent.assertionError((String)PageFactoryApiMessages.COMPONENT_NOT_PRESENT.getMessage(new Object[]{componentName, element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addSuppressedException((Throwable)exception).setAttachment(exception.getAttachment().orElse(Attachment.empty())).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
            throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        });
    }

    protected void shouldNotBePresent(WebChildElement element, String componentName) {
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(element);
        WebElementOperation<Boolean> operation = WebElementIsPresentOperationHandler.of(element, operationType, componentName).getOperation().withPageSource();
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifSuccess(successOperationResult -> {
            boolean present = (Boolean)successOperationResult.getResult();
            if (present) {
                throw ElementIsPresent.assertionError((String)PageFactoryApiMessages.COMPONENT_IS_PRESENT.getMessage(new Object[]{componentName, element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)HtmlAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
        });
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (!(exception instanceof JsElementSearch)) {
                throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
            }
        });
    }
}

