/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.element.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.ElementIsDisplayed;
import io.perfeccionista.framework.exceptions.ElementNotDisplayed;
import io.perfeccionista.framework.exceptions.attachments.Attachment;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.HtmlAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.exceptions.js.JsElementSearch;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.element.WebTableMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebTable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.mapping.WebTableFrame;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsDisplayedOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import org.jetbrains.annotations.NotNull;

public class WebTableShouldHaveColumnMatcher
implements WebTableMatcher {
    private final String columnName;
    private final boolean positive;

    public WebTableShouldHaveColumnMatcher(@NotNull String columnName, boolean positive) {
        this.columnName = columnName;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebTable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ColumnShouldBeDisplayed", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ColumnShouldNotBeDisplayed", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            if (this.positive) {
                this.shouldBeDisplayed(element, this.columnName);
            } else {
                this.shouldNotBeDisplayed(element, this.columnName);
            }
        });
    }

    protected void shouldBeDisplayed(WebTable element, String componentName) {
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator();
        tableLocatorChain.addLastLocator(element.getRequiredLocator("THEAD")).addLastLocator(webTableRegistry.getRequiredHeaderLocator(this.columnName));
        WebBlock columnBlock = webTableRegistry.getRequiredHeaderMappedBlock(this.columnName);
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(columnBlock);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(columnBlock, operationType, "DISPLAYED").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (exception instanceof JsElementSearch) {
                throw ElementNotDisplayed.assertionError((String)PageFactoryApiMessages.COMPONENT_NOT_DISPLAYED.getMessage(new Object[]{componentName, element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addSuppressedException((Throwable)exception).setAttachment(exception.getAttachment().orElse(Attachment.with((AttachmentEntry[])new AttachmentEntry[0]))).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
            throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        });
        boolean displayed = operationResult.getResult();
        if (!displayed) {
            throw ElementNotDisplayed.assertionError((String)PageFactoryApiMessages.ELEMENT_NOT_DISPLAYED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
        }
    }

    protected void shouldNotBeDisplayed(WebTable element, String componentName) {
        WebTableFrame<WebBlock> webTableRegistry = element.getWebTableFrame();
        WebLocatorChain tableLocatorChain = element.getLocatorChain();
        WebLocatorHolder tableLocatorHolder = tableLocatorChain.getLastLocator();
        tableLocatorChain.addLastLocator(element.getRequiredLocator("THEAD")).addLastLocator(webTableRegistry.getRequiredHeaderLocator(this.columnName));
        WebBlock columnBlock = webTableRegistry.getRequiredHeaderMappedBlock(this.columnName);
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(columnBlock);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(columnBlock, operationType, "DISPLAYED").getOperation();
        operation.getLocatorChain().addFirstLocators(tableLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation);
        operationResult.ifSuccess(successOperationResult -> {
            boolean displayed = (Boolean)successOperationResult.getResult();
            if (displayed) {
                throw ElementIsDisplayed.assertionError((String)PageFactoryApiMessages.COMPONENT_IS_DISPLAYED.getMessage(new Object[]{componentName, element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)HtmlAttachmentEntry.of((String)"OuterHtml", (String)operationResult.getPageSource()));
            }
        });
        operationResult.ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            if (!(exception instanceof JsElementSearch)) {
                throw exception.addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
            }
        });
    }
}

