/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabUrl;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebBrowserShouldHaveTabWithUrlStringMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final String expectedText;
    protected final boolean positive;

    public WebBrowserShouldHaveTabWithUrlStringMatcher(String expectedText, boolean positive) {
        this.expectedText = expectedText;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserShouldHaveTabWithUrl", (Object[])new Object[]{this, this.expectedText}) : InvocationInfo.assertInvocation((String)"BrowserShouldNotHaveTabWithUrl", (Object[])new Object[]{this, this.expectedText});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            List<String> actualTabUrls = tabsDispatcher.getAllTabUrls();
            if (this.positive) {
                this.shouldHaveTabWithUrl(tabsDispatcher, actualTabUrls);
            } else {
                this.shouldNotHaveTabWithUrl(tabsDispatcher, actualTabUrls);
            }
        });
    }

    protected void shouldHaveTabWithUrl(WebBrowserTabsDispatcher tabsDispatcher, List<String> actualTabUrls) {
        if (!actualTabUrls.contains(this.expectedText)) {
            throw WebBrowserTabUrl.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_DOES_NOT_CONTAIN_TAB_WITH_EXPECTED_URL.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)String.join((CharSequence)"', '", actualTabUrls)));
        }
    }

    protected void shouldNotHaveTabWithUrl(WebBrowserTabsDispatcher tabsDispatcher, List<String> actualTabUrls) {
        if (actualTabUrls.contains(this.expectedText)) {
            throw WebBrowserTabUrl.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_CONTAINS_TAB_WITH_EXPECTED_URL.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)String.join((CharSequence)"', '", actualTabUrls)));
        }
    }
}

