/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabTitle;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebBrowserShouldHaveTabWithTitleStringValueMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final StringValue expectedTextValue;
    protected final boolean positive;

    public WebBrowserShouldHaveTabWithTitleStringValueMatcher(StringValue expectedTextValue, boolean positive) {
        this.expectedTextValue = expectedTextValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserShouldHaveTabWithTitleValue", (Object[])new Object[]{this, this.expectedTextValue}) : InvocationInfo.assertInvocation((String)"BrowserShouldNotHaveTabWithTitleValue", (Object[])new Object[]{this, this.expectedTextValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            List<String> actualTabTitles = tabsDispatcher.getAllTabTitles();
            if (this.positive) {
                this.shouldHaveTabWithTitle(tabsDispatcher, actualTabTitles);
            } else {
                this.shouldNotHaveTabWithTitle(tabsDispatcher, actualTabTitles);
            }
        });
    }

    protected void shouldHaveTabWithTitle(WebBrowserTabsDispatcher tabsDispatcher, List<String> actualTabTitles) {
        boolean match = actualTabTitles.stream().anyMatch(arg_0 -> ((StringValue)this.expectedTextValue).check(arg_0));
        if (!match) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_DOES_NOT_CONTAIN_TAB_WITH_EXPECTED_TITLE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedTextValue, (String)String.join((CharSequence)"', '", actualTabTitles)));
        }
    }

    protected void shouldNotHaveTabWithTitle(WebBrowserTabsDispatcher tabsDispatcher, List<String> actualTabTitles) {
        boolean match = actualTabTitles.stream().anyMatch(arg_0 -> ((StringValue)this.expectedTextValue).check(arg_0));
        if (match) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_CONTAINS_TAB_WITH_EXPECTED_TITLE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedTextValue, (String)String.join((CharSequence)"', '", actualTabTitles)));
        }
    }
}

