/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabCount;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import io.perfeccionista.framework.value.number.NumberValue;
import org.jetbrains.annotations.NotNull;

public class WebBrowserShouldHaveTabCountNumberValueMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final NumberValue<Integer> expectedNumberValue;
    protected final boolean positive;

    public WebBrowserShouldHaveTabCountNumberValueMatcher(NumberValue<Integer> expectedNumberValue, boolean positive) {
        this.expectedNumberValue = expectedNumberValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserShouldHaveTabsCountNumberValue", (Object[])new Object[]{this, this.expectedNumberValue}) : InvocationInfo.assertInvocation((String)"BrowserShouldNotHaveTabsCountNumberValue", (Object[])new Object[]{this, this.expectedNumberValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            int actualTabCount = tabsDispatcher.getTabCount();
            if (this.positive) {
                this.shouldHaveTabCount(tabsDispatcher, actualTabCount);
            } else {
                this.shouldNotHaveTabCount(tabsDispatcher, actualTabCount);
            }
        });
    }

    protected void shouldHaveTabCount(WebBrowserTabsDispatcher tabsDispatcher, int actualTabCount) {
        if (!this.expectedNumberValue.check((Object)actualTabCount)) {
            throw WebBrowserTabCount.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_TAB_COUNT_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of(this.expectedNumberValue));
        }
    }

    protected void shouldNotHaveTabCount(WebBrowserTabsDispatcher tabsDispatcher, int actualTabCount) {
        if (this.expectedNumberValue.check((Object)actualTabCount)) {
            throw WebBrowserTabCount.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_TAB_COUNT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of(this.expectedNumberValue));
        }
    }
}

