/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabUrl;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import org.jetbrains.annotations.NotNull;

public class WebBrowserActiveTabShouldHaveUrlStringMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final String expectedText;
    protected final boolean positive;

    public WebBrowserActiveTabShouldHaveUrlStringMatcher(String expectedText, boolean positive) {
        this.expectedText = expectedText;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldHaveUrl", (Object[])new Object[]{this, this.expectedText}) : InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldNotHaveUrl", (Object[])new Object[]{this, this.expectedText});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualActiveTabUrlText = tabsDispatcher.getActiveTabUrl();
            if (this.positive) {
                this.shouldHaveUrl(tabsDispatcher, actualActiveTabUrlText);
            } else {
                this.shouldNotHaveUrl(tabsDispatcher, actualActiveTabUrlText);
            }
        });
    }

    protected void shouldHaveUrl(WebBrowserTabsDispatcher tabsDispatcher, String actualUrl) {
        if (!this.expectedText.equals(actualUrl)) {
            throw WebBrowserTabUrl.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_URL_TEXT_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualUrl));
        }
    }

    protected void shouldNotHaveUrl(WebBrowserTabsDispatcher tabsDispatcher, String actualUrl) {
        if (this.expectedText.equals(actualUrl)) {
            throw WebBrowserTabUrl.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_URL_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualUrl));
        }
    }
}

