/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabTitle;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import io.perfeccionista.framework.value.string.StringValue;
import org.jetbrains.annotations.NotNull;

public class WebBrowserActiveTabShouldHaveTitleStringValueMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final StringValue expectedStringValue;
    protected final boolean positive;

    public WebBrowserActiveTabShouldHaveTitleStringValueMatcher(StringValue expectedStringValue, boolean positive) {
        this.expectedStringValue = expectedStringValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldHaveTitleValue", (Object[])new Object[]{this, this.expectedStringValue}) : InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldNotHaveTitleValue", (Object[])new Object[]{this, this.expectedStringValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualActiveTabTitleText = tabsDispatcher.getActiveTabTitle();
            if (this.positive) {
                this.shouldHaveTitle(tabsDispatcher, actualActiveTabTitleText);
            } else {
                this.shouldNotHaveTitle(tabsDispatcher, actualActiveTabTitleText);
            }
        });
    }

    protected void shouldHaveTitle(WebBrowserTabsDispatcher tabsDispatcher, String actualTitle) {
        if (!this.expectedStringValue.check((Object)actualTitle)) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_TITLE_TEXT_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }

    protected void shouldNotHaveTitle(WebBrowserTabsDispatcher tabsDispatcher, String actualTitle) {
        if (this.expectedStringValue.check((Object)actualTitle)) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_TITLE_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }
}

