/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.dispatcher.implementations;

import io.perfeccionista.framework.exceptions.WebBrowserTabTitle;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.dispatcher.WebBrowserTabsDispatcherMatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.tabs.WebBrowserTabsDispatcher;
import org.jetbrains.annotations.NotNull;

public class WebBrowserActiveTabShouldHaveTitleStringMatcher
implements WebBrowserTabsDispatcherMatcher {
    protected final String expectedText;
    protected final boolean positive;

    public WebBrowserActiveTabShouldHaveTitleStringMatcher(String expectedText, boolean positive) {
        this.expectedText = expectedText;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebBrowserTabsDispatcher tabsDispatcher) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldHaveTitle", (Object[])new Object[]{this, this.expectedText}) : InvocationInfo.assertInvocation((String)"BrowserActiveTabShouldNotHaveTitle", (Object[])new Object[]{this, this.expectedText});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualActiveTabTitleText = tabsDispatcher.getActiveTabTitle();
            if (this.positive) {
                this.shouldHaveTitle(tabsDispatcher, actualActiveTabTitleText);
            } else {
                this.shouldNotHaveTitle(tabsDispatcher, actualActiveTabTitleText);
            }
        });
    }

    protected void shouldHaveTitle(WebBrowserTabsDispatcher tabsDispatcher, String actualTitle) {
        if (!this.expectedText.equals(actualTitle)) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_TITLE_TEXT_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualTitle));
        }
    }

    protected void shouldNotHaveTitle(WebBrowserTabsDispatcher tabsDispatcher, String actualTitle) {
        if (this.expectedText.equals(actualTitle)) {
            throw WebBrowserTabTitle.assertionError(PageFactoryWebApiMessages.WEB_BROWSER_ACTIVE_TAB_TITLE_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Tabs", (String)tabsDispatcher.getDescription())).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualTitle));
        }
    }
}

