/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.invocation;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.attachments.processor.AttachmentProcessor;
import io.perfeccionista.framework.extension.PerfeccionistaExtension;
import io.perfeccionista.framework.invocation.DefaultInvocationServiceConfiguration;
import io.perfeccionista.framework.invocation.InvocationService;
import io.perfeccionista.framework.invocation.runner.EmptyInvocationRunner;
import io.perfeccionista.framework.invocation.runner.InvocationRunner;
import io.perfeccionista.framework.service.DefaultServiceConfiguration;
import io.perfeccionista.framework.service.ServiceConfiguration;
import io.perfeccionista.framework.utils.CastUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;

@DefaultServiceConfiguration(value=DefaultInvocationServiceConfiguration.class)
public class JUnit5InvocationService
extends InvocationService {
    private Set<AttachmentProcessor> testAttachmentProcessors = new HashSet<AttachmentProcessor>();

    public void init(@NotNull Environment environment) {
        super.init(environment);
        this.resolveTestAttachmentProcessors(environment);
    }

    public void init(@NotNull Environment environment, @NotNull ServiceConfiguration configuration) {
        super.init(environment, configuration);
        this.resolveTestAttachmentProcessors(environment);
    }

    @NotNull
    public Class<? extends InvocationRunner> getInvocationRunnerImplementation(@NotNull Class<?> invocationWrapper) {
        return this.configuration == null ? EmptyInvocationRunner.class : this.configuration.getInvocationRunnerImplementation(invocationWrapper);
    }

    @NotNull
    public Set<AttachmentProcessor> getAttachmentProcessors() {
        Set attachmentProcessors = this.configuration.getAttachmentProcessors();
        this.testAttachmentProcessors.forEach(attachmentProcessors::add);
        return attachmentProcessors;
    }

    protected void resolveTestAttachmentProcessors(Environment environment) {
        Optional.ofNullable(environment.getRelatedObjects().get("Context")).ifPresent(context -> {
            if (CastUtils.isSubtypeOf((Object)context, ExtensionContext.class)) {
                ExtensionContext extensionContext = (ExtensionContext)context;
                Optional requiredTestMethod = extensionContext.getTestMethod();
                Optional requiredTestClass = extensionContext.getTestClass();
                if (requiredTestMethod.isPresent() && requiredTestClass.isPresent()) {
                    this.testAttachmentProcessors.addAll(PerfeccionistaExtension.resolveAttachmentProcessors((Method)requiredTestMethod.get(), (Class)requiredTestClass.get()));
                }
            }
        });
    }
}

