package io.perfeccionista.framework.repeater.policy;

/**
 * Режим политики перезапусков тестов, которая используется по-умолчанию
 * для всех тестов, запускающихся под заданной конфигурацией.
 */
public enum RepeatMode {

    /**
     * Повторения отключены
     */
    NO_REPEAT,

    /**
     * Повторять если выполнится условие и количество попыток повторения
     * позволяет это сделать
     */
    REPEAT_IF,

    /**
     * Повторять пока не выполнится условие и количество попыток повторения
     * позволяет это сделать
     */
    REPEAT_BEFORE;

}
