/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.repeater;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.IncorrectServiceConfiguration;
import io.perfeccionista.framework.exceptions.messages.EnvironmentMessages;
import io.perfeccionista.framework.repeater.DefaultRepeatPolicyServiceConfiguration;
import io.perfeccionista.framework.repeater.RepeatPolicyServiceConfiguration;
import io.perfeccionista.framework.repeater.policy.NoRepeatPolicy;
import io.perfeccionista.framework.repeater.policy.RepeatPolicy;
import io.perfeccionista.framework.service.DefaultServiceConfiguration;
import io.perfeccionista.framework.service.Service;
import io.perfeccionista.framework.service.ServiceConfiguration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@DefaultServiceConfiguration(value=DefaultRepeatPolicyServiceConfiguration.class)
public class RepeatPolicyService
implements Service {
    protected Environment environment;
    protected RepeatPolicyServiceConfiguration configuration = null;

    public void init(@NotNull Environment environment, @NotNull ServiceConfiguration configuration) {
        this.environment = environment;
        this.configuration = this.validate(configuration);
    }

    public RepeatPolicy getRepeatPolicy() {
        if (Objects.isNull(this.configuration)) {
            return new NoRepeatPolicy();
        }
        return this.configuration.getRepeatPolicy();
    }

    protected RepeatPolicyServiceConfiguration validate(ServiceConfiguration configuration) {
        if (configuration instanceof RepeatPolicyServiceConfiguration) {
            return (RepeatPolicyServiceConfiguration)configuration;
        }
        throw IncorrectServiceConfiguration.exception((String)EnvironmentMessages.SERVICE_CONFIGURATION_NOT_VALID.getMessage(new Object[]{configuration.getClass().getCanonicalName(), this.getClass().getCanonicalName()}));
    }
}

