/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.repeater.iterators;

import io.perfeccionista.framework.extension.PerfeccionistaExtension;
import io.perfeccionista.framework.repeater.RepeaterInvocationContext;
import io.perfeccionista.framework.repeater.policy.RepeatPolicy;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public class RepeatIfTestTemplateIterator
implements Iterator<TestTemplateInvocationContext> {
    private final PerfeccionistaExtension extension;
    private final RepeatPolicy repeatPolicy;
    private final String displayName;
    private final Method method;
    private int currentIndex = 0;

    public RepeatIfTestTemplateIterator(PerfeccionistaExtension extension, RepeatPolicy repeatPolicy, String displayName, Method method) {
        this.extension = extension;
        this.repeatPolicy = repeatPolicy;
        this.displayName = displayName;
        this.method = method;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex < this.repeatPolicy.minAttempt()) {
            return true;
        }
        return this.currentIndex < this.repeatPolicy.maxAttempt() && this.repeatPolicy.getRepeatCondition().testCondition(this.extension.getThreadLocalTestResults(this.method));
    }

    @Override
    public TestTemplateInvocationContext next() {
        if (this.hasNext()) {
            return new RepeaterInvocationContext(this.displayName, ++this.currentIndex);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

