/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.extension;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.EnvironmentConfiguration;
import io.perfeccionista.framework.UseEnvironment;
import io.perfeccionista.framework.exceptions.EnvironmentNotConfigured;
import io.perfeccionista.framework.exceptions.RepeatPolicyInitialization;
import io.perfeccionista.framework.exceptions.TestClassNotFound;
import io.perfeccionista.framework.exceptions.TestMethodNotFound;
import io.perfeccionista.framework.exceptions.messages.EnvironmentMessages;
import io.perfeccionista.framework.repeater.RepeatPolicyService;
import io.perfeccionista.framework.repeater.TestRepeatedOnCondition;
import io.perfeccionista.framework.repeater.iterators.NoRepeatTestTemplateIterator;
import io.perfeccionista.framework.repeater.iterators.RepeatIfTestTemplateIterator;
import io.perfeccionista.framework.repeater.iterators.RepeatWhileTestTemplateIterator;
import io.perfeccionista.framework.repeater.policy.NoRepeatPolicy;
import io.perfeccionista.framework.repeater.policy.RepeatPolicy;
import io.perfeccionista.framework.utils.EnvironmentConfigurationResolver;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import io.perfeccionista.framework.value.ValueService;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestExecutionResult;

public class PerfeccionistaExtension
implements ParameterResolver,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
TestTemplateInvocationContextProvider,
TestExecutionExceptionHandler,
TestWatcher {
    private static final Logger logger = LoggerFactory.getLogger(PerfeccionistaExtension.class);
    protected ThreadLocal<Environment> activeEnvironment = new ThreadLocal();
    protected ThreadLocal<Map<Method, Deque<TestExecutionResult>>> threadLocalTestResults = new ThreadLocal();

    PerfeccionistaExtension() {
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
    }

    public void beforeEach(ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> TestClassNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_CLASS_NOT_FOUND.getMessage(new Object[0])));
        Method testMethod = (Method)context.getTestMethod().orElseThrow(() -> TestMethodNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_METHOD_NOT_FOUND.getMessage(new Object[0])));
        Optional<Class<? extends EnvironmentConfiguration>> optionalTestMethodConfiguration = this.findEnvironmentConfiguration(testMethod);
        if (optionalTestMethodConfiguration.isPresent()) {
            Class<? extends EnvironmentConfiguration> testMethodConfiguration = optionalTestMethodConfiguration.get();
            this.resolveActiveEnvironmentForTestMethod(testMethodConfiguration);
            return;
        }
        Optional<Class<? extends EnvironmentConfiguration>> optionalTestClassConfiguration = this.findEnvironmentConfiguration(testClass);
        if (optionalTestClassConfiguration.isPresent()) {
            Class<? extends EnvironmentConfiguration> testClassConfiguration = optionalTestClassConfiguration.get();
            this.resolveActiveEnvironmentForTestMethod(testClassConfiguration);
            return;
        }
        this.resolveActiveEnvironmentForTestMethod();
    }

    public void afterEach(ExtensionContext context) {
        Optional<Environment> environmentInstanceForCurrentThread = this.getActiveEnvironment();
        environmentInstanceForCurrentThread.ifPresent(environment -> {
            environment.shutdown();
            environment.removeEnvironmentForCurrentThread();
        });
        this.activeEnvironment.remove();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return Environment.class.isAssignableFrom(parameterContext.getParameter().getType()) || ValueService.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Optional<Environment> environmentInstanceForCurrentThread = this.getActiveEnvironment();
        Environment environment = environmentInstanceForCurrentThread.orElseThrow(() -> EnvironmentNotConfigured.exception((String)EnvironmentMessages.ENVIRONMENT_NOT_DECLARED.getErrorMessage()));
        if (ValueService.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return environment.getService(ValueService.class);
        }
        return environment;
    }

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return AnnotationUtils.isAnnotated((Optional)extensionContext.getTestMethod(), TestRepeatedOnCondition.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Iterator<TestTemplateInvocationContext> iterator;
        Class<? extends RepeatPolicy> repeatPolicyClass;
        Optional optionalAnnotation;
        Environment environment;
        Optional optionalRepeatPolicyService;
        Method testMethod = (Method)context.getTestMethod().orElseThrow(() -> TestMethodNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_METHOD_NOT_FOUND.getErrorMessage()));
        RepeatPolicy repeatPolicy = new NoRepeatPolicy();
        Optional<Environment> optionalEnvironment = this.getActiveEnvironment();
        if (optionalEnvironment.isPresent() && (optionalRepeatPolicyService = (environment = optionalEnvironment.get()).getOptionalService(RepeatPolicyService.class)).isPresent()) {
            repeatPolicy = ((RepeatPolicyService)optionalRepeatPolicyService.get()).getRepeatPolicy();
        }
        if ((optionalAnnotation = context.getTestMethod().flatMap(testMethods -> AnnotationUtils.findAnnotation((AnnotatedElement)testMethods, TestRepeatedOnCondition.class))).isPresent() && !RepeatPolicy.class.equals(repeatPolicyClass = ((TestRepeatedOnCondition)optionalAnnotation.get()).value())) {
            if (ReflectionUtils.isAbstract(repeatPolicyClass) || repeatPolicyClass.isInterface()) {
                throw RepeatPolicyInitialization.exception((String)EnvironmentMessages.CREATE_REPEAT_POLICY_INSTANCE_EXCEPTION.getMessage(new Object[]{repeatPolicyClass}));
            }
            repeatPolicy = (RepeatPolicy)ReflectionUtils.newInstance(repeatPolicyClass, (Object[])new Object[0]);
        }
        Preconditions.condition((repeatPolicy.minAttempt() > 0 ? 1 : 0) != 0, (String)"Total repeats must be higher than 0");
        Preconditions.condition((repeatPolicy.maxAttempt() > 0 ? 1 : 0) != 0, (String)"Total minimum success must be higher than 0");
        switch (repeatPolicy.getRepeatMode()) {
            case REPEAT_IF: {
                iterator = new RepeatIfTestTemplateIterator(this, repeatPolicy, context.getDisplayName(), testMethod);
                break;
            }
            case REPEAT_BEFORE: {
                iterator = new RepeatWhileTestTemplateIterator(this, repeatPolicy, context.getDisplayName(), testMethod);
                break;
            }
            default: {
                iterator = new NoRepeatTestTemplateIterator(context.getDisplayName());
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 256), false);
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
    }

    public void testSuccessful(ExtensionContext context) {
        Method testMethod = (Method)context.getTestMethod().orElseThrow(() -> TestMethodNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_METHOD_NOT_FOUND.getErrorMessage()));
        this.getThreadLocalTestResults(testMethod).addLast(TestExecutionResult.successful());
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        Method testMethod = (Method)context.getTestMethod().orElseThrow(() -> TestMethodNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_METHOD_NOT_FOUND.getErrorMessage()));
        this.getThreadLocalTestResults(testMethod).addLast(TestExecutionResult.aborted((Throwable)cause));
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        Method testMethod = (Method)context.getTestMethod().orElseThrow(() -> TestMethodNotFound.exception((String)EnvironmentMessages.UNEXPECTED_TEST_METHOD_NOT_FOUND.getErrorMessage()));
        this.getThreadLocalTestResults(testMethod).addLast(TestExecutionResult.failed((Throwable)cause));
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        throw throwable;
    }

    protected Optional<Class<? extends EnvironmentConfiguration>> findEnvironmentConfiguration(Class<?> testClass) {
        Class<?> processedClass = testClass;
        while (!Object.class.equals(processedClass)) {
            Optional optionalAnnotation = AnnotationUtils.findAnnotation(processedClass, UseEnvironment.class);
            if (optionalAnnotation.isPresent()) {
                return Optional.of(((UseEnvironment)optionalAnnotation.get()).value());
            }
            processedClass = processedClass.getSuperclass();
        }
        return Optional.empty();
    }

    protected Optional<Class<? extends EnvironmentConfiguration>> findEnvironmentConfiguration(Method testMethod) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, UseEnvironment.class).map(UseEnvironment::value);
    }

    protected <T extends Environment> T createEnvironment(@NotNull EnvironmentConfiguration environmentConfiguration) {
        Constructor constructor = ReflectionUtilsForClasses.getConstructor((Class)environmentConfiguration.getEnvironmentClass(), (Class[])new Class[]{EnvironmentConfiguration.class});
        return (T)((Environment)ReflectionUtils.newInstance((Constructor)constructor, (Object[])new Object[]{environmentConfiguration}));
    }

    protected void resolveActiveEnvironmentForTestMethod(Class<? extends EnvironmentConfiguration> configurationClass) {
        Environment environmentInstance = this.createEnvironment((EnvironmentConfiguration)ReflectionUtils.newInstance(configurationClass, (Object[])new Object[0])).setEnvironmentForCurrentThread().init();
        this.activeEnvironment.set(environmentInstance);
    }

    protected void resolveActiveEnvironmentForTestMethod() {
        Environment environmentInstance = this.createEnvironment(EnvironmentConfigurationResolver.resolveEnvironmentConfiguration()).setEnvironmentForCurrentThread().init();
        this.activeEnvironment.set(environmentInstance);
    }

    protected Optional<Environment> getActiveEnvironment() {
        return Optional.ofNullable(this.activeEnvironment.get());
    }

    @NotNull
    public Deque<TestExecutionResult> getThreadLocalTestResults(Method method) {
        Map<Method, Deque<TestExecutionResult>> threadLocalTestResultMap = this.threadLocalTestResults.get();
        if (null == threadLocalTestResultMap) {
            HashMap<Method, ArrayDeque<TestExecutionResult>> newThreadLocalTestResultMap = new HashMap<Method, ArrayDeque<TestExecutionResult>>();
            ArrayDeque<TestExecutionResult> newTestResults = new ArrayDeque<TestExecutionResult>();
            newThreadLocalTestResultMap.put(method, newTestResults);
            this.threadLocalTestResults.set(newThreadLocalTestResultMap);
            return newTestResults;
        }
        Deque<TestExecutionResult> testResults = threadLocalTestResultMap.get(method);
        if (null == testResults) {
            ArrayDeque<TestExecutionResult> newTestResults = new ArrayDeque<TestExecutionResult>();
            threadLocalTestResultMap.put(method, newTestResults);
            return newTestResults;
        }
        return new ArrayDeque<TestExecutionResult>(testResults);
    }
}

