/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.testrunconfigcommand;

import io.perfana.events.testrunconfigcommand.JsonConverter;
import io.perfana.events.testrunconfigcommand.PrefixedRedirectOutput;
import io.perfana.events.testrunconfigcommand.TestRunConfigCommandEventContext;
import io.perfana.eventscheduler.api.EventAdapter;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.message.EventMessage;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import io.perfana.eventscheduler.util.TestRunConfigUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class TestRunConfigCommandEvent
extends EventAdapter<TestRunConfigCommandEventContext> {
    public static final Pattern REGEX_SPLIT_QUOTES = Pattern.compile("\"([^\"]*)\"|(\\S+)");

    public TestRunConfigCommandEvent(TestRunConfigCommandEventContext eventContext, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)eventContext, messageBus, logger);
    }

    public void beforeTest() {
        String pluginName = TestRunConfigCommandEvent.class.getSimpleName() + "-" + ((TestRunConfigCommandEventContext)this.eventContext).getName();
        String command = ((TestRunConfigCommandEventContext)this.eventContext).getCommand();
        this.logger.info("About to run [" + command + "] for [" + ((TestRunConfigCommandEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
        List<String> commandList = this.splitCommand(command);
        try {
            String commandOutput = new ProcessExecutor().command(commandList).readOutput(true).redirectError((OutputStream)new PrefixedRedirectOutput(((TestRunConfigCommandEventContext)this.eventContext).getName() + ": ", System.err)).timeout(30L, TimeUnit.SECONDS).exitValue(Integer.valueOf(0)).execute().outputUTF8();
            String output = ((TestRunConfigCommandEventContext)this.eventContext).getOutput();
            if ("keys".equals(output)) {
                Map<String, String> flatJson = JsonConverter.flatten(commandOutput, ((TestRunConfigCommandEventContext)this.eventContext).getIncludes(), ((TestRunConfigCommandEventContext)this.eventContext).getExcludes());
                this.logger.info("About to send " + flatJson.size() + " flattened key-value pairs");
                this.logger.debug("flatJsonMap: " + flatJson);
                EventMessage message = TestRunConfigUtil.createTestRunConfigMessageKeys((String)pluginName, flatJson, (String)((TestRunConfigCommandEventContext)this.eventContext).getTags());
                this.eventMessageBus.send(message);
            } else {
                EventMessage message = TestRunConfigUtil.createTestRunConfigMessage((String)pluginName, (String)((TestRunConfigCommandEventContext)this.eventContext).getKey(), (String)commandOutput, (String)output, (String)((TestRunConfigCommandEventContext)this.eventContext).getTags(), (String)((TestRunConfigCommandEventContext)this.eventContext).getExcludes(), (String)((TestRunConfigCommandEventContext)this.eventContext).getIncludes());
                this.eventMessageBus.send(message);
            }
        }
        catch (InvalidExitValueException e) {
            throw new EventSchedulerRuntimeException("Unexpected exit value.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EventSchedulerRuntimeException("IO exception to run command: [" + command + "]", (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EventSchedulerRuntimeException("Got interrupted during command [" + command + "]");
        }
        catch (TimeoutException e) {
            throw new EventSchedulerRuntimeException("Got timeout for command [" + command + "]", (Exception)e);
        }
    }

    private List<String> splitCommand(String command) {
        Matcher m = REGEX_SPLIT_QUOTES.matcher(command);
        ArrayList<String> commandList = new ArrayList<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                commandList.add(m.group(1));
                continue;
            }
            commandList.add(m.group(2));
        }
        return commandList;
    }
}

