/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.testrunconfigcommand;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.jcip.annotations.GuardedBy;

public class PrefixedRedirectOutput
extends OutputStream {
    private static final int BUFFER_SIZE = 1024;
    private final Object bufferLock = new Object();
    @GuardedBy(value="bufferLock")
    private final byte[] buffer = new byte[1024];
    @GuardedBy(value="bufferLock")
    private int pointer;
    private final byte[] prefix;
    private final OutputStream wrappedOS;
    private final String newLine = System.lineSeparator();
    private final int[] nl = this.newLine.chars().toArray();
    private final int chars = this.nl.length;
    private volatile boolean start = true;
    private volatile boolean thereIsMore = false;

    public PrefixedRedirectOutput(String prefix, OutputStream wrappedOS) {
        this.prefix = prefix.getBytes(StandardCharsets.UTF_8);
        this.wrappedOS = wrappedOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (this.start) {
            this.start = false;
            this.wrappedOS.write(this.prefix);
        }
        if (this.thereIsMore) {
            this.wrappedOS.write(this.prefix);
            this.thereIsMore = false;
        }
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer[this.pointer++] = (byte)b;
            if (this.pointer == 1024) {
                this.flushBuffer();
            }
        }
        if (this.chars == 1 && this.nl[0] == b || this.chars == 2 && this.nl[1] == b) {
            this.thereIsMore = true;
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.wrappedOS.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.wrappedOS.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.write(this.prefix);
        this.write(" END!".getBytes(StandardCharsets.UTF_8));
        this.write(this.newLine.getBytes(StandardCharsets.UTF_8));
        this.wrappedOS.close();
    }
}

