/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.testrunconfigcommand;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import io.perfana.eventscheduler.util.JavaArgsParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JsonConverter {
    private static final JsonMapper jsonMapper = (JsonMapper)JsonMapper.builder().build();
    private static final Pattern CONTAINER_ENV_PATTERN = Pattern.compile("spec.template.spec.containers\\.\\d+\\.env");

    private JsonConverter() {
    }

    public static Map<String, String> flatten(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JsonConverter.addKeys("", jsonMapper.readTree(json), map);
        }
        catch (IOException e) {
            throw new EventSchedulerRuntimeException("failed to parse json", (Exception)e);
        }
        return map;
    }

    public static Map<String, String> flatten(String json, List<String> includes, List<String> excludes) {
        if (includes.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> map = JsonConverter.flatten(json);
        Map<String, String> inclMap = map.entrySet().stream().filter(e -> JsonConverter.isMentionedIn((String)e.getKey(), includes)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return inclMap.entrySet().stream().filter(e -> !JsonConverter.isMentionedIn((String)e.getKey(), excludes)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> flatten(String json, String includesAsCommaSepList, String excludesAsCommaSepList) {
        return JsonConverter.flatten(json, JsonConverter.commaSepToList(includesAsCommaSepList), JsonConverter.commaSepToList(excludesAsCommaSepList));
    }

    private static boolean isMentionedIn(String key, List<String> listOfKeyParts) {
        return listOfKeyParts.stream().anyMatch(key::contains);
    }

    private static void addKeys(String currentPath, JsonNode jsonNode, Map<String, String> map) {
        if (jsonNode.isObject()) {
            String pathPrefix = currentPath.isEmpty() ? "" : currentPath + ".";
            JsonConverter.addFieldsOfObject(pathPrefix, (ObjectNode)jsonNode, map);
        } else if (jsonNode.isArray()) {
            if (CONTAINER_ENV_PATTERN.matcher(currentPath).matches()) {
                JsonConverter.addNameValuePairs(currentPath, (ArrayNode)jsonNode, map);
            } else {
                JsonConverter.addKeysOfArray(currentPath, (ArrayNode)jsonNode, map);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            map.put(currentPath, valueNode.asText());
        }
    }

    private static void addKeysOfArray(String pathPrefix, ArrayNode jsonNode, Map<String, String> map) {
        for (int i = 0; i < jsonNode.size(); ++i) {
            JsonConverter.addKeys(pathPrefix + "." + i, jsonNode.get(i), map);
        }
    }

    private static void addFieldsOfObject(String pathPrefix, ObjectNode jsonNode, Map<String, String> map) {
        Iterator iter = jsonNode.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            JsonConverter.addKeys(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), map);
        }
    }

    private static void addNameValuePairs(String pathPrefix, ArrayNode jsonNode, Map<String, String> map) {
        for (int i = 0; i < jsonNode.size(); ++i) {
            JsonNode propNode = jsonNode.get(i);
            String name = propNode.get("name").asText();
            String value = JsonConverter.getK8sPropValue(propNode);
            if (JavaArgsParser.isJavaCommandArgsProperty((String)name)) {
                Map jvmArgsMap = JavaArgsParser.createJvmArgsTestConfigLines((String)value);
                jvmArgsMap.forEach((n, v) -> map.put(pathPrefix + "." + name + "." + n, (String)v));
                continue;
            }
            map.put(pathPrefix + "." + name, value);
        }
    }

    private static String getK8sPropValue(JsonNode propNode) {
        JsonNode node = propNode.get("value");
        if (node == null && (node = propNode.get("valueFrom")) != null) {
            Iterator fields = node.fields();
            String field = fields.hasNext() ? (String)((Map.Entry)fields.next()).getKey() : "unkown";
            return "[valueFrom:" + field + "]";
        }
        if (node == null) {
            return "[no value or valueFrom found]";
        }
        return node.textValue();
    }

    static List<String> commaSepToList(String commaSepList) {
        if (commaSepList == null || commaSepList.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(commaSepList.split(",")).collect(Collectors.toList());
    }
}

