/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.event;

import io.perfana.events.springboot.event.SpringBootEventContext;
import io.perfana.eventscheduler.api.config.EventConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SpringBootEventConfig
extends EventConfig {
    private String tags = "";
    private String actuatorPropPrefix = "actuator";
    private String actuatorBaseUrl;
    private String actuatorEnvProperties;
    private String dumpPath;

    public void setTags(String tags) {
        this.tags = tags;
    }

    private List<String> createEnvProps() {
        return this.actuatorEnvProperties == null ? Collections.emptyList() : Arrays.stream(this.actuatorEnvProperties.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public SpringBootEventContext toContext() {
        List<String> envProps = this.createEnvProps();
        return new SpringBootEventContext(super.toContext(), this.tags, this.actuatorPropPrefix, this.actuatorBaseUrl, envProps, this.dumpPath);
    }

    public String toString() {
        return "SpringBootEventConfig{tags='" + this.tags + "', actuatorPropPrefix(Deprecated)='" + this.actuatorPropPrefix + "', actuatorBaseUrl='" + this.actuatorBaseUrl + "', actuatorEnvProperties='" + this.actuatorEnvProperties + "', dumpPath='" + this.dumpPath + "'} " + super.toString();
    }

    public String getActuatorBaseUrl() {
        return this.actuatorBaseUrl;
    }

    public void setActuatorBaseUrl(String actuatorBaseUrl) {
        this.actuatorBaseUrl = actuatorBaseUrl;
    }

    public String getActuatorEnvProperties() {
        return this.actuatorEnvProperties;
    }

    public void setActuatorEnvProperties(String actuatorEnvProperties) {
        this.actuatorEnvProperties = actuatorEnvProperties;
    }

    @Deprecated(forRemoval=true)
    public String getActuatorPropPrefix() {
        return this.actuatorPropPrefix;
    }

    @Deprecated(forRemoval=true)
    public void setActuatorPropPrefix(String actuatorPropPrefix) {
        this.actuatorPropPrefix = actuatorPropPrefix;
    }

    public String getDumpPath() {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) {
        this.dumpPath = dumpPath;
    }
}

