/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.event;

import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventGenerator;
import io.perfana.eventscheduler.api.EventGeneratorProperties;
import io.perfana.eventscheduler.api.EventLogger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class SpringBootEventGenerator
implements EventGenerator {
    private static final String INPUT_FILE_TAG = "input-file";
    private final EventLogger logger;
    private final EventGeneratorProperties properties;

    SpringBootEventGenerator(EventGeneratorProperties properties, EventLogger logger) {
        this.properties = properties;
        this.logger = logger;
    }

    public List<CustomEvent> generate() {
        String slowbackendFilePath = this.properties.getProperty(INPUT_FILE_TAG);
        if (slowbackendFilePath == null) {
            throw new RuntimeException("unable to find setting for: input-file");
        }
        this.logger.info("SpringBootEventGenerator: using input-file path: " + slowbackendFilePath);
        ArrayList<CustomEvent> events = new ArrayList<CustomEvent>();
        events.add(new CustomEvent(Duration.of(1L, ChronoUnit.SECONDS), "hello-world", "phase 1", "{}"));
        return events;
    }
}

