/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.event;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.OkHttpClient;
import io.perfana.events.springboot.actuator.ActuatorClient;
import io.perfana.events.springboot.actuator.OkHttpClientFactory;
import io.perfana.events.springboot.actuator.Variable;
import io.perfana.events.springboot.event.SpringBootEventContext;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventAdapter;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.message.EventMessage;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.exception.EventSchedulerRuntimeException;
import io.perfana.eventscheduler.util.JavaArgsParser;
import io.perfana.eventscheduler.util.TestRunConfigUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringBootEvent
extends EventAdapter<SpringBootEventContext> {
    public static final String ACTUATOR_TAG = "actuator";
    private ActuatorClient actuatorClient;
    private final Gson gson = new Gson();
    private OkHttpClient okHttpClient = OkHttpClientFactory.instance();
    private final Set<String> allowedCustomEvents = SpringBootEvent.setOf((String[])((String[])AllowedCustomEvents.stream().map(AllowedCustomEvents::getEventName).toArray(String[]::new)));

    void injectOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public SpringBootEvent(SpringBootEventContext eventContext, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)eventContext, messageBus, logger);
        this.eventMessageBus.addReceiver(m -> logger.debug("Received message: " + m));
    }

    public Collection<String> allowedCustomEvents() {
        return this.allowedCustomEvents;
    }

    public void beforeTest() {
        this.logger.info("Fetching actuator values for [" + ((SpringBootEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
        String pluginName = SpringBootEvent.class.getSimpleName() + "-" + ((SpringBootEventContext)this.eventContext).getName();
        String tags = this.filterAndCombineTagsForTestRunConfigCall();
        Map<String, String> keyValues = this.createTestRunKeyValues();
        List<Variable> variables = this.getActuatorVariables();
        variables.forEach(v -> keyValues.put(v.getName(), v.getValue()));
        EventMessage message = TestRunConfigUtil.createTestRunConfigMessageKeys((String)pluginName, keyValues, (String)tags);
        this.eventMessageBus.send(message);
        this.eventMessageBus.send(EventMessage.builder().pluginName(pluginName).message("Go!").build());
    }

    private Map<String, String> createTestRunKeyValues() {
        String prefix = "event." + ((SpringBootEventContext)this.eventContext).getName() + ".";
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(prefix + "dumpPath", ((SpringBootEventContext)this.eventContext).getDumpPath());
        keyValues.put(prefix + "actuatorEnvProperties", String.join((CharSequence)"\n", ((SpringBootEventContext)this.eventContext).getActuatorEnvProperties()));
        keyValues.put(prefix + "actuatorBaseUrl", ((SpringBootEventContext)this.eventContext).getActuatorBaseUrl());
        return keyValues;
    }

    private List<Variable> getActuatorVariables() {
        String actuatorBaseUrl = ((SpringBootEventContext)this.eventContext).getActuatorBaseUrl();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (actuatorBaseUrl != null) {
            this.actuatorClient = new ActuatorClient(actuatorBaseUrl, this.okHttpClient, this.logger);
            List<String> actuatorEnvProperties = ((SpringBootEventContext)this.eventContext).getActuatorEnvProperties();
            this.logger.debug("Requested actuatorEnvProperties: " + actuatorEnvProperties);
            List<Variable> actuatorKeyValues = this.actuatorClient.queryActuator(actuatorEnvProperties);
            this.logger.debug("Found actuator values: " + actuatorKeyValues);
            List<Variable> processedVariables = SpringBootEvent.processJavaArgsLikeOptions(actuatorKeyValues);
            variables.addAll(processedVariables);
            String info = this.actuatorClient.info();
            this.logger.debug("Application info: " + info);
            if (info.contains("version")) {
                try {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map infoMap = (Map)this.gson.fromJson(info, type);
                    Map build = (Map)infoMap.get("build");
                    String version = (String)build.get("version");
                    variables.add(new Variable("version", version));
                }
                catch (Exception e) {
                    this.logger.warn("cannot retrieve version from info object: " + info);
                }
            }
        }
        this.logger.debug("All processed actuator values: " + variables);
        return variables;
    }

    static List<Variable> processJavaArgsLikeOptions(List<Variable> actuatorKeyValues) {
        ArrayList<Variable> clonedVariables = new ArrayList<Variable>(actuatorKeyValues);
        List<Variable> javaArgsVariables = actuatorKeyValues.stream().filter(v -> JavaArgsParser.isJavaCommandArgsProperty((String)v.getName())).collect(Collectors.toList());
        clonedVariables.removeAll(javaArgsVariables);
        javaArgsVariables.forEach(v -> SpringBootEvent.addAllJvmArgOptions(clonedVariables, v));
        return clonedVariables;
    }

    private static void addAllJvmArgOptions(List<Variable> clonedVariables, Variable v) {
        JavaArgsParser.createJvmArgsTestConfigLines((String)v.getValue()).forEach((k, v2) -> clonedVariables.add(new Variable(v.getName() + "." + k, (String)v2)));
    }

    private String filterAndCombineTagsForTestRunConfigCall() {
        String actuatorPropPrefix = ((SpringBootEventContext)this.eventContext).getActuatorPropPrefix();
        String tags = ((SpringBootEventContext)this.eventContext).getTags();
        ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(tags.split(",")));
        List tagsAsListNoEmpties = splitList.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (!tagsAsListNoEmpties.contains(actuatorPropPrefix)) {
            tagsAsListNoEmpties.add(actuatorPropPrefix);
        }
        if (!tagsAsListNoEmpties.contains(ACTUATOR_TAG)) {
            tagsAsListNoEmpties.add(ACTUATOR_TAG);
        }
        return String.join((CharSequence)",", tagsAsListNoEmpties);
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        try {
            if (AllowedCustomEvents.threaddump.hasEventName(eventName)) {
                this.threadDumpEvent(scheduleEvent);
            } else if (AllowedCustomEvents.heapdump.hasEventName(eventName)) {
                this.heapDumpEvent(scheduleEvent);
            } else {
                this.logger.warn("ignoring unknown event [" + eventName + "]");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to run custom event: " + eventName, (Throwable)e);
        }
    }

    private void heapDumpEvent(CustomEvent scheduleEvent) {
        this.logger.info("Start " + scheduleEvent);
        File dumpPath = this.sanityPath(((SpringBootEventContext)this.eventContext).getDumpPath());
        String filename = this.uniqueFileNameFromTags();
        this.logger.info("Heap dump for " + filename);
        this.actuatorClient.heapdump(dumpPath, filename);
    }

    private String uniqueFileNameFromTags() {
        String testRunId = ((SpringBootEventContext)this.eventContext).getTestContext().getTestRunId();
        String tags = ((SpringBootEventContext)this.eventContext).getTags();
        if (tags.isEmpty()) {
            return testRunId;
        }
        String tagsForName = tags.replace(',', '-');
        return this.sanitizeFilename(testRunId + "-" + tagsForName);
    }

    private String sanitizeFilename(String filename) {
        return filename.replaceAll("[:\\\\/*?|<>]", "_");
    }

    private void threadDumpEvent(CustomEvent scheduleEvent) {
        this.logger.info("Start " + scheduleEvent);
        File dumpPath = this.sanityPath(((SpringBootEventContext)this.eventContext).getDumpPath());
        String filename = this.uniqueFileNameFromTags();
        this.logger.info("stack dump event for test [" + filename + "]");
        this.actuatorClient.threaddump(dumpPath, filename);
    }

    private File sanityPath(String dumpPath) {
        File dumpDir;
        if (dumpPath == null || dumpPath.trim().isEmpty()) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null || tmpDir.trim().isEmpty()) {
                throw new EventSchedulerRuntimeException("No java.io.tmpdir env found, better define explicit dumpPath in config.");
            }
            dumpDir = new File(tmpDir);
        } else {
            dumpDir = new File(dumpPath);
        }
        if (!dumpDir.exists()) {
            throw new EventSchedulerRuntimeException("Dir does not exist: " + dumpDir);
        }
        if (!dumpDir.isDirectory()) {
            throw new EventSchedulerRuntimeException("Dir is not a directory: " + dumpDir);
        }
        if (!dumpDir.canWrite()) {
            throw new EventSchedulerRuntimeException("Dir is not writeable: " + dumpDir);
        }
        return dumpDir;
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    static enum AllowedCustomEvents {
        heapdump("heapdump"),
        threaddump("threaddump");

        private final String eventName;

        private AllowedCustomEvents(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static Stream<AllowedCustomEvents> stream() {
            return Stream.of(AllowedCustomEvents.values());
        }

        public boolean hasEventName(String name) {
            return this.eventName.equals(name);
        }
    }
}

