/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.actuator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.perfana.events.springboot.actuator.ActuatorClientException;
import io.perfana.events.springboot.actuator.ActuatorEnvs;
import io.perfana.events.springboot.actuator.BinaryFileDownloader;
import io.perfana.events.springboot.actuator.BinaryFileWriter;
import io.perfana.events.springboot.actuator.Value;
import io.perfana.events.springboot.actuator.Variable;
import io.perfana.eventscheduler.api.EventLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ActuatorClient {
    private final String baseUrl;
    private final Gson gson = new GsonBuilder().create();
    private final OkHttpClient okHttpClient;
    private final EventLogger logger;
    private static final int retries = 2;
    private static final List<Integer> retryCodes = List.of(Integer.valueOf(408), Integer.valueOf(425), Integer.valueOf(429), Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503), Integer.valueOf(504));
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssSSS");

    public ActuatorClient(String actuatorUrl, OkHttpClient okHttpClient, EventLogger logger) {
        this.baseUrl = actuatorUrl;
        this.okHttpClient = okHttpClient;
        this.logger = logger;
    }

    public List<Variable> queryActuator(List<String> envKeys) {
        String totalUrl = this.baseUrl + "/env";
        try {
            String result = this.remoteCall(totalUrl);
            ActuatorEnvs envs = (ActuatorEnvs)this.gson.fromJson(result, ActuatorEnvs.class);
            return envs.propertySources.stream().flatMap(propertySource -> this.filterAndPrefixProperties(propertySource.name, envKeys, propertySource.properties.entrySet())).collect(Collectors.toList());
        }
        catch (ActuatorClientException ex) {
            this.logger.error("Cannot get " + totalUrl, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public String info() {
        String totalUrl = this.baseUrl + "/info";
        try {
            return this.remoteCall(totalUrl);
        }
        catch (ActuatorClientException ex) {
            this.logger.error("Cannot get " + totalUrl, (Throwable)ex);
            return "{}";
        }
    }

    private String remoteCall(String url) throws ActuatorClientException {
        int count = 0;
        while (true) {
            ++count;
            try {
                Request request = new Request.Builder().url(url).get().build();
                Response response = this.okHttpClient.newCall(request).execute();
                int code = response.code();
                if (code != 200) {
                    String message = "Unexpected status code (not 200): " + code + " for " + request.url() + ": " + response.message();
                    if (count <= 2 && retryCodes.contains(code)) {
                        this.logger.warn("Retry (" + count + "/2) for call: " + message);
                        this.waitForRetry();
                        continue;
                    }
                    throw new ActuatorClientException(message);
                }
                return response.body().string();
            }
            catch (IOException e) {
                String message = "Cannot get " + url;
                if (count <= 2) {
                    this.logger.warn("Retry (" + count + "/2) for call: " + message + " cause: " + e.getMessage());
                    this.waitForRetry();
                    continue;
                }
                throw new ActuatorClientException(message, e);
            }
            break;
        }
    }

    private void waitForRetry() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void heapdump(File path, String fileId) {
        String totalUrl = this.baseUrl + "/heapdump";
        File file = new File(path, "heapdump-" + fileId + "-" + this.fileTimeStamp() + ".hprof");
        this.downloadAndSave(file, totalUrl);
        this.logger.info("wrote heap dump to " + file);
    }

    private String fileTimeStamp() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }

    public void threaddump(File path, String filename) {
        String totalUrl = this.baseUrl + "/threaddump";
        File file = new File(path, "threaddump-" + filename + "-" + this.fileTimeStamp() + ".txt");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "text/plain");
        this.downloadAndSave(file, totalUrl, headers);
        this.logger.info("wrote thread dump to " + file);
    }

    private void downloadAndSave(File file, String url) {
        this.downloadAndSave(file, url, Collections.emptyMap());
    }

    private void downloadAndSave(File file, String url, Map<String, String> headers) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(fos);){
                BinaryFileWriter writer = new BinaryFileWriter(outputStream);
                BinaryFileDownloader downloader = new BinaryFileDownloader(this.okHttpClient, writer);
                downloader.download(url, headers);
            }
        }
        catch (IOException e) {
            this.logger.error("Create heap dump and save heap dump failed.", (Throwable)e);
        }
    }

    private Stream<Variable> filterAndPrefixProperties(String prefix, List<String> propertyNames, Set<Map.Entry<String, Value>> propertiesSet) {
        return propertiesSet.stream().filter(entry -> propertyNames.contains(entry.getKey())).map(entry -> new Variable(prefix + ":" + (String)entry.getKey(), ((Value)entry.getValue()).value));
    }
}

