/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.event;

import io.perfana.events.springboot.event.SpringBootEventContext;
import io.perfana.eventscheduler.api.config.EventConfig;
import io.perfana.eventscheduler.api.config.TestContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SpringBootEventConfig
extends EventConfig {
    private String myEventTags;
    private String actuatorPropPrefix = "actuator";
    private String actuatorBaseUrl;
    private String actuatorEnvProperties;
    private String dumpPath;

    public void setMyEventTags(String myEventTags) {
        this.myEventTags = myEventTags;
    }

    private List<String> createEnvProps() {
        return this.actuatorEnvProperties == null ? Collections.emptyList() : Arrays.asList(this.actuatorEnvProperties.split(","));
    }

    public SpringBootEventContext toContext() {
        List<String> envProps = this.createEnvProps();
        return new SpringBootEventContext(super.toContext(), this.myEventTags, this.actuatorPropPrefix, this.actuatorBaseUrl, envProps, this.dumpPath);
    }

    public SpringBootEventContext toContext(TestContext override) {
        List<String> envProps = this.createEnvProps();
        return new SpringBootEventContext(super.toContext(override), this.myEventTags, this.actuatorPropPrefix, this.actuatorBaseUrl, envProps, this.dumpPath);
    }

    public String toString() {
        return "SpringBootEventConfig{myEventTags='" + this.myEventTags + '\'' + ", actuatorPropPrefix='" + this.actuatorPropPrefix + '\'' + ", actuatorBaseUrl='" + this.actuatorBaseUrl + '\'' + ", actuatorEnvProperties='" + this.actuatorEnvProperties + '\'' + ", dumpPath='" + this.dumpPath + '\'' + "} " + super.toString();
    }

    public String getActuatorBaseUrl() {
        return this.actuatorBaseUrl;
    }

    public void setActuatorBaseUrl(String actuatorBaseUrl) {
        this.actuatorBaseUrl = actuatorBaseUrl;
    }

    public String getActuatorEnvProperties() {
        return this.actuatorEnvProperties;
    }

    public void setActuatorEnvProperties(String actuatorEnvProperties) {
        this.actuatorEnvProperties = actuatorEnvProperties;
    }

    public String getActuatorPropPrefix() {
        return this.actuatorPropPrefix;
    }

    public void setActuatorPropPrefix(String actuatorPropPrefix) {
        this.actuatorPropPrefix = actuatorPropPrefix;
    }

    public String getDumpPath() {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) {
        this.dumpPath = dumpPath;
    }
}

