/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.event;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.perfana.events.springboot.actuator.ActuatorClient;
import io.perfana.events.springboot.actuator.Variable;
import io.perfana.events.springboot.event.SpringBootEventContext;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventAdapter;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.message.EventMessage;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringBootEvent
extends EventAdapter<SpringBootEventContext> {
    private ActuatorClient actuatorClient;
    private final Gson gson = new Gson();
    private final Set<String> allowedCustomEvents = SpringBootEvent.setOf((String[])((String[])AllowedCustomEvents.stream().map(AllowedCustomEvents::getEventName).toArray(String[]::new)));

    public SpringBootEvent(SpringBootEventContext eventContext, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)eventContext, messageBus, logger);
        this.eventMessageBus.addReceiver(m -> logger.info("Received message: " + m));
    }

    public Collection<String> allowedCustomEvents() {
        return this.allowedCustomEvents;
    }

    public void beforeTest() {
        this.logger.info("Fetching actuator values for [" + ((SpringBootEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
        String pluginName = SpringBootEvent.class.getSimpleName() + "-" + ((SpringBootEventContext)this.eventContext).getName();
        String actuatorBaseUrl = ((SpringBootEventContext)this.eventContext).getActuatorBaseUrl();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (actuatorBaseUrl != null) {
            this.actuatorClient = new ActuatorClient(actuatorBaseUrl, this.logger);
            variables.addAll(this.actuatorClient.queryActuator(((SpringBootEventContext)this.eventContext).getActuatorEnvProperties()));
            String info = this.actuatorClient.info();
            this.logger.info("Application info: " + info);
            if (info.contains("version")) {
                try {
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map infoMap = (Map)this.gson.fromJson(info, type);
                    Map build = (Map)infoMap.get("build");
                    String version = (String)build.get("version");
                    variables.add(new Variable("version", version));
                }
                catch (Exception e) {
                    this.logger.warn("cannot retrieve version from info object: " + info);
                }
            }
        }
        EventMessage.EventMessageBuilder builder = EventMessage.builder();
        String actuatorPropPrefix = ((SpringBootEventContext)this.eventContext).getActuatorPropPrefix();
        variables.forEach(v -> builder.variable(actuatorPropPrefix + "-" + v.getName(), v.getValue()));
        this.eventMessageBus.send(builder.pluginName(pluginName).build());
        this.eventMessageBus.send(EventMessage.builder().pluginName(pluginName).message("Go!").build());
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        try {
            if (AllowedCustomEvents.threaddump.hasEventName(eventName)) {
                this.threadDumpEvent(scheduleEvent);
            } else if (AllowedCustomEvents.heapdump.hasEventName(eventName)) {
                this.heapDumpEvent(scheduleEvent);
            } else {
                this.logger.warn("ignoring unknown event [" + eventName + "]");
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to run custom event: " + eventName, (Throwable)e);
        }
    }

    private void heapDumpEvent(CustomEvent scheduleEvent) {
        this.logger.info("Start " + scheduleEvent);
        File dumpPath = this.sanityPath(((SpringBootEventContext)this.eventContext).getDumpPath());
        String testRunId = ((SpringBootEventContext)this.eventContext).getTestContext().getTestRunId();
        this.logger.info("Heap dump for " + testRunId);
        this.actuatorClient.heapdump(dumpPath, testRunId);
    }

    private void threadDumpEvent(CustomEvent scheduleEvent) {
        this.logger.info("Start " + scheduleEvent);
        File dumpPath = this.sanityPath(((SpringBootEventContext)this.eventContext).getDumpPath());
        String testRunId = ((SpringBootEventContext)this.eventContext).getTestContext().getTestRunId();
        this.logger.info("stack dump event for test [" + testRunId + "]");
        this.actuatorClient.threaddump(dumpPath, testRunId);
    }

    private File sanityPath(String dumpPath) {
        File dumpDir;
        if (dumpPath == null || dumpPath.trim().isEmpty()) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null || tmpDir.trim().isEmpty()) {
                throw new RuntimeException("No java.io.tmpdir env found, better define explicit dumpPath in config.");
            }
            dumpDir = new File(tmpDir);
        } else {
            dumpDir = new File(dumpPath);
        }
        if (!dumpDir.exists()) {
            throw new RuntimeException("Dir does not exist: " + dumpDir);
        }
        if (!dumpDir.isDirectory()) {
            throw new RuntimeException("Dir is not a directory: " + dumpDir);
        }
        if (!dumpDir.canWrite()) {
            throw new RuntimeException("Dir is not writeable: " + dumpDir);
        }
        return dumpDir;
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    static enum AllowedCustomEvents {
        heapdump("heapdump"),
        threaddump("threaddump");

        private final String eventName;

        private AllowedCustomEvents(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static Stream<AllowedCustomEvents> stream() {
            return Stream.of(AllowedCustomEvents.values());
        }

        public boolean hasEventName(String name) {
            return this.eventName.equals(name);
        }
    }
}

