/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.actuator;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.perfana.events.springboot.actuator.BinaryFileWriter;
import java.io.IOException;
import java.util.Map;

public class BinaryFileDownloader
implements AutoCloseable {
    private final OkHttpClient client;
    private final BinaryFileWriter writer;

    public BinaryFileDownloader(OkHttpClient client, BinaryFileWriter writer) {
        this.client = client;
        this.writer = writer;
    }

    public void download(String url, Map<String, String> headers) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
        Request request = requestBuilder.build();
        Response response = this.client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new IllegalStateException("Response doesn't contain a file");
        }
        this.writer.write(responseBody.byteStream());
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

