/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.events.springboot.actuator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.perfana.events.springboot.actuator.ActuatorEnvs;
import io.perfana.events.springboot.actuator.BinaryFileDownloader;
import io.perfana.events.springboot.actuator.BinaryFileWriter;
import io.perfana.events.springboot.actuator.Value;
import io.perfana.events.springboot.actuator.Variable;
import io.perfana.eventscheduler.api.EventLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ActuatorClient {
    private final String baseUrl;
    private final Gson gson = new GsonBuilder().create();
    private final OkHttpClient okHttpClient = new OkHttpClient();
    private final EventLogger logger;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssSSS");

    public ActuatorClient(String actuatorUrl, EventLogger logger) {
        this.baseUrl = actuatorUrl;
        this.logger = logger;
        this.okHttpClient.setConnectTimeout(800L, TimeUnit.MILLISECONDS);
        this.okHttpClient.setReadTimeout(1800L, TimeUnit.MILLISECONDS);
        this.okHttpClient.setWriteTimeout(1800L, TimeUnit.MILLISECONDS);
    }

    public List<Variable> queryActuator(List<String> envKeys) {
        String totalUrl = this.baseUrl + "/env";
        try {
            Request request = new Request.Builder().url(totalUrl).get().build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.code() != 200) {
                this.logger.error("Unexpected status code (not 200): " + response.code() + " for " + request.url() + " : " + response.body());
                return Collections.emptyList();
            }
            String body = response.body().string();
            ActuatorEnvs envs = (ActuatorEnvs)this.gson.fromJson(body, ActuatorEnvs.class);
            return envs.propertySources.stream().flatMap(propertySource -> this.filterAndPrefixProperties(propertySource.name, envKeys, propertySource.properties.entrySet())).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.logger.error("Cannot get " + totalUrl, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String info() {
        String totalUrl = this.baseUrl + "/info";
        try {
            Request request = new Request.Builder().url(totalUrl).get().build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.code() != 200) {
                this.logger.error("Unexpected status code (not 200): " + response.code() + " for " + request.url() + " : " + response.body());
                return "{}";
            }
            return response.body().string();
        }
        catch (IOException e) {
            this.logger.error("Cannot get " + totalUrl, (Throwable)e);
            return "{}}";
        }
    }

    public void heapdump(File path, String fileId) {
        String totalUrl = this.baseUrl + "/heapdump";
        File file = new File(path, "heapdump-" + fileId + "-" + this.fileTimeStamp() + ".bin");
        this.downloadAndSave(file, totalUrl);
        this.logger.info("wrote heap dump to " + file);
    }

    private String fileTimeStamp() {
        return DATE_TIME_FORMATTER.format(LocalDateTime.now());
    }

    public void threaddump(File path, String filename) {
        String totalUrl = this.baseUrl + "/threaddump";
        File file = new File(path, "threaddump-" + filename + "-" + this.fileTimeStamp() + ".txt");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "text/plain");
        this.downloadAndSave(file, totalUrl, headers);
        this.logger.info("wrote thread dump to " + file);
    }

    private void downloadAndSave(File file, String url) {
        this.downloadAndSave(file, url, Collections.emptyMap());
    }

    private void downloadAndSave(File file, String url, Map<String, String> headers) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(fos);){
                BinaryFileWriter writer = new BinaryFileWriter(outputStream);
                BinaryFileDownloader downloader = new BinaryFileDownloader(this.okHttpClient, writer);
                downloader.download(url, headers);
            }
        }
        catch (IOException e) {
            this.logger.error("Create heapdump and save heapdump failed.", (Throwable)e);
        }
    }

    private Stream<Variable> filterAndPrefixProperties(String prefix, List<String> propertyNames, Set<Map.Entry<String, Value>> propertiesSet) {
        return propertiesSet.stream().filter(entry -> propertyNames.contains(entry.getKey())).map(entry -> new Variable(prefix + ":" + (String)entry.getKey(), ((Value)entry.getValue()).value));
    }
}

