/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event.loadrunner;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.perfana.event.loadrunner.LoadRunnerCloudClientException;
import io.perfana.event.loadrunner.api.Auth;
import io.perfana.event.loadrunner.api.RunReply;
import io.perfana.event.loadrunner.api.RuntimeAdditionalAttribute;
import io.perfana.event.loadrunner.api.Schedule;
import io.perfana.event.loadrunner.api.ScheduleReply;
import io.perfana.event.loadrunner.api.ScriptConfig;
import io.perfana.event.loadrunner.api.TestRunActive;
import io.perfana.event.loadrunner.api.Token;
import io.perfana.eventscheduler.api.EventLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.cookie.BasicClientCookie;

class LoadRunnerCloudClient {
    public static final String PARAM_TENANTID = "TENANTID";
    private static final String PARAM_RUN_ACTION = "action";
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private final ObjectReader tokenReader = this.objectMapper.readerFor(Token.class);
    private final ObjectReader scheduleReplyReader = this.objectMapper.readerFor(ScheduleReply.class);
    private final ObjectReader runReplyReader = this.objectMapper.readerFor(RunReply.class);
    private final ObjectReader scriptConfigArrayReader = this.objectMapper.readerFor(ScriptConfig[].class);
    private final ObjectReader runtimeAdditionalAttributeArrayReader = this.objectMapper.readerFor(RuntimeAdditionalAttribute[].class);
    private final ObjectReader testRunsActiveArrayReader = this.objectMapper.readerFor(TestRunActive[].class);
    private final ObjectWriter authWriter = this.objectMapper.writerFor(Auth.class);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final EventLogger logger;
    private final BasicCookieStore cookieStore = new BasicCookieStore();
    private final String host;
    private final int proxyPort;
    private volatile boolean isCookiePresent = false;
    private volatile String tenantId;

    public LoadRunnerCloudClient(String baseUrl, EventLogger logger) {
        this(baseUrl, logger, false, 8888);
    }

    public LoadRunnerCloudClient(String baseUrl, EventLogger logger, boolean useProxy, int proxyPort) {
        try {
            URL url = new URL(baseUrl);
            this.host = url.getHost();
        }
        catch (MalformedURLException e) {
            throw new LoadRunnerCloudClientException("Invalid base url provided: " + baseUrl, e);
        }
        this.baseUrl = this.removeLastSlashIfPresent(baseUrl);
        this.logger = logger;
        this.httpClient = this.createHttpClient(useProxy);
        this.proxyPort = proxyPort;
    }

    private String removeLastSlashIfPresent(String url) {
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public void initApiKey(String user, String password, String tenantId) {
        this.notEmpty(user, "user");
        this.notEmpty(password, "password");
        this.notEmpty(tenantId, "tenantId");
        String apiKey = this.fetchApiKey(this.baseUrl, user, password, tenantId);
        this.tenantId = tenantId;
        BasicClientCookie cookie = new BasicClientCookie("LWSSO_COOKIE_KEY", apiKey);
        cookie.setDomain(this.host);
        cookie.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie);
        this.isCookiePresent = true;
    }

    private void notEmpty(String user, String name) {
        if (user == null || user.isEmpty()) {
            throw new LoadRunnerCloudClientException(name + " is null or empty");
        }
    }

    private String fetchApiKey(String baseUrl, String user, String password, String tenantId) {
        try {
            URIBuilder uriBuilder = new URIBuilder(baseUrl + "/auth");
            uriBuilder.addParameter(PARAM_TENANTID, tenantId);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            Auth auth = Auth.builder().user(user).password(password).build();
            String json = this.authWriter.writeValueAsString((Object)auth);
            StringEntity data = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)data);
            HttpResponse response = this.executeRequest((HttpUriRequest)httpPost);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            Token token = (Token)this.tokenReader.readValue(result);
            return token.getToken();
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    private void checkApiKey() {
        if (!this.isCookiePresent) {
            throw new LoadRunnerCloudClientException("No LoadRunner cloud client api key present. First call initApiKey with credentials.");
        }
    }

    private HttpClient createHttpClient(boolean useProxy) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(4000).setSocketTimeout(10000).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCookieStore((CookieStore)this.cookieStore).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig);
        if (useProxy) {
            HttpHost httpProxy = new HttpHost("localhost", this.proxyPort);
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(httpProxy);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return httpClientBuilder.build();
    }

    private static String responseToString(HttpResponse response) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        return result.toString();
    }

    private HttpResponse executeRequest(HttpUriRequest request) throws IOException {
        HttpResponse response = this.httpClient.execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode > 299) {
            String result = LoadRunnerCloudClient.responseToString(response);
            throw new LoadRunnerCloudClientException(String.format("Unexpected status code: %d for request: %s. Contents: %s", statusCode, request, result));
        }
        return response;
    }

    public ScheduleReply createSchedule(String projectId, String loadTestId) {
        this.checkApiKey();
        String uri = String.format("%s/projects/%s/load-tests/%s/schedules", this.baseUrl, projectId, loadTestId);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            ZonedDateTime startTime = ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(1L);
            Schedule schedule = Schedule.builder().timestamp(startTime).build();
            String json = this.objectMapper.writeValueAsString((Object)schedule);
            StringEntity data = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)data);
            HttpResponse response = this.executeRequest((HttpUriRequest)httpPost);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return (ScheduleReply)this.scheduleReplyReader.readValue(result);
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    public RunReply startRun(String projectId, String loadTestId) {
        this.checkApiKey();
        String uri = String.format("%s/projects/%s/load-tests/%s/runs", this.baseUrl, projectId, loadTestId);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            HttpResponse response = this.executeRequest((HttpUriRequest)httpPost);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return (RunReply)this.runReplyReader.readValue(result);
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    public RunReply stopRun(int runId) {
        this.checkApiKey();
        String uri = String.format("%s/test-runs/%d", this.baseUrl, runId);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            uriBuilder.addParameter(PARAM_RUN_ACTION, "STOP");
            HttpPut httpPut = new HttpPut(uriBuilder.build());
            HttpResponse response = this.executeRequest((HttpUriRequest)httpPut);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return (RunReply)this.runReplyReader.readValue(result);
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    public List<ScriptConfig> scriptsForTestRun(String projectId, String loadTestId) {
        this.checkApiKey();
        String uri = String.format("%s/projects/%s/load-tests/%s/scripts", this.baseUrl, projectId, loadTestId);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            HttpResponse response = this.executeRequest((HttpUriRequest)httpGet);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return Arrays.asList((ScriptConfig[])this.scriptConfigArrayReader.readValue(result));
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    public List<RuntimeAdditionalAttribute> addAdditionalRuntimeSettingsAttributes(String projectId, String loadTestId, int loadTestScriptId, List<RuntimeAdditionalAttribute> attributes) {
        this.checkApiKey();
        String uri = String.format("%s/projects/%s/load-tests/%s/scripts/%d/rts/additional-attributes", this.baseUrl, projectId, loadTestId, loadTestScriptId);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            HttpPut httpPut = new HttpPut(uriBuilder.build());
            String json = this.objectMapper.writeValueAsString(attributes);
            StringEntity data = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)data);
            HttpResponse response = this.executeRequest((HttpUriRequest)httpPut);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return Arrays.asList((RuntimeAdditionalAttribute[])this.runtimeAdditionalAttributeArrayReader.readValue(result));
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }

    public void addAdditionalRuntimeSettingsAttributesForAllScriptsOfTest(String projectId, String loadTestId, List<RuntimeAdditionalAttribute> attributes) {
        int scriptCount;
        List<ScriptConfig> scriptConfigs = this.scriptsForTestRun(projectId, loadTestId);
        this.logger.info("Updating " + scriptCount + " " + ((scriptCount = scriptConfigs.size()) == 1 ? "script" : "scripts") + " with local runtime settings attributes: " + attributes);
        scriptConfigs.stream().map(ScriptConfig::getId).forEach(scriptId -> this.addAdditionalRuntimeSettingsAttributes(projectId, loadTestId, (int)scriptId, attributes));
    }

    public List<TestRunActive> testRunsActive(String projectId) {
        this.checkApiKey();
        String uri = String.format("%s/test-runs/active", this.baseUrl);
        try {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter(PARAM_TENANTID, this.tenantId);
            uriBuilder.addParameter("projectIds", projectId);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            HttpResponse response = this.executeRequest((HttpUriRequest)httpGet);
            String result = LoadRunnerCloudClient.responseToString(response);
            this.logger.debug(result);
            return Arrays.asList((TestRunActive[])this.testRunsActiveArrayReader.readValue(result));
        }
        catch (IOException | URISyntaxException e) {
            throw new LoadRunnerCloudClientException("call to LoadRunner cloud failed", e);
        }
    }
}

