/*
 * Copyright (C) 2023 Peter Paul Bakker, Perfana
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.perfana.event.loadrunner.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.*;

@Value
@Builder
@NoArgsConstructor(force = true, access = AccessLevel.PRIVATE)
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class ScriptConfig {
    int id;
    int scriptId;
    String name;
    Boolean isGitScript;
    Boolean isActive;
    int vusersNum;
    long startTime;
    String schedulingMode;
    RampUp rampUp;
    long duration;
    TearDown tearDown;
    int pacing;
    boolean isLocalPacingEnabled;
    boolean isLocalRtsEnabled;
    int locationType;
    int iterations;
    long maxDuration;
    int percentage;
}
