/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event.loadrunner.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TestRunActive {
    private final int runId;
    private final int testId;
    private final int projectId;
    private final String testName;
    private final long startTime;
    private final String triggeredBy;
    private final Status status;

    public static TestRunActiveBuilder builder() {
        return new TestRunActiveBuilder();
    }

    public int getRunId() {
        return this.runId;
    }

    public int getTestId() {
        return this.testId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getTestName() {
        return this.testName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getTriggeredBy() {
        return this.triggeredBy;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRunActive)) {
            return false;
        }
        TestRunActive other = (TestRunActive)o;
        if (this.getRunId() != other.getRunId()) {
            return false;
        }
        if (this.getTestId() != other.getTestId()) {
            return false;
        }
        if (this.getProjectId() != other.getProjectId()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        String this$testName = this.getTestName();
        String other$testName = other.getTestName();
        if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
            return false;
        }
        String this$triggeredBy = this.getTriggeredBy();
        String other$triggeredBy = other.getTriggeredBy();
        if (this$triggeredBy == null ? other$triggeredBy != null : !this$triggeredBy.equals(other$triggeredBy)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRunId();
        result = result * 59 + this.getTestId();
        result = result * 59 + this.getProjectId();
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        String $testName = this.getTestName();
        result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
        String $triggeredBy = this.getTriggeredBy();
        result = result * 59 + ($triggeredBy == null ? 43 : $triggeredBy.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "TestRunActive(runId=" + this.getRunId() + ", testId=" + this.getTestId() + ", projectId=" + this.getProjectId() + ", testName=" + this.getTestName() + ", startTime=" + this.getStartTime() + ", triggeredBy=" + this.getTriggeredBy() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    private TestRunActive() {
        this.runId = 0;
        this.testId = 0;
        this.projectId = 0;
        this.testName = null;
        this.startTime = 0L;
        this.triggeredBy = null;
        this.status = null;
    }

    public TestRunActive(int runId, int testId, int projectId, String testName, long startTime, String triggeredBy, Status status) {
        this.runId = runId;
        this.testId = testId;
        this.projectId = projectId;
        this.testName = testName;
        this.startTime = startTime;
        this.triggeredBy = triggeredBy;
        this.status = status;
    }

    public static class TestRunActiveBuilder {
        private int runId;
        private int testId;
        private int projectId;
        private String testName;
        private long startTime;
        private String triggeredBy;
        private Status status;

        TestRunActiveBuilder() {
        }

        public TestRunActiveBuilder runId(int runId) {
            this.runId = runId;
            return this;
        }

        public TestRunActiveBuilder testId(int testId) {
            this.testId = testId;
            return this;
        }

        public TestRunActiveBuilder projectId(int projectId) {
            this.projectId = projectId;
            return this;
        }

        public TestRunActiveBuilder testName(String testName) {
            this.testName = testName;
            return this;
        }

        public TestRunActiveBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public TestRunActiveBuilder triggeredBy(String triggeredBy) {
            this.triggeredBy = triggeredBy;
            return this;
        }

        public TestRunActiveBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public TestRunActive build() {
            return new TestRunActive(this.runId, this.testId, this.projectId, this.testName, this.startTime, this.triggeredBy, this.status);
        }

        public String toString() {
            return "TestRunActive.TestRunActiveBuilder(runId=" + this.runId + ", testId=" + this.testId + ", projectId=" + this.projectId + ", testName=" + this.testName + ", startTime=" + this.startTime + ", triggeredBy=" + this.triggeredBy + ", status=" + (Object)((Object)this.status) + ")";
        }
    }

    public static enum Status {
        RUNNING,
        INITIALIZING,
        CHECKING_STATUS,
        STOPPING,
        PAUSED;

    }
}

