/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event.loadrunner;

import io.perfana.event.loadrunner.LoadRunnerCloudEventContext;
import java.time.Duration;
import nl.stokpop.eventscheduler.api.config.EventConfig;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.config.TestContext;

public class LoadRunnerCloudEventConfig
extends EventConfig {
    private String loadRunnerUser;
    private String loadRunnerPassword;
    private String loadRunnerTenantId;
    private String loadRunnerProjectId;
    private String loadRunnerLoadTestId;
    private boolean loadRunnerUseTracingHeader = false;
    private int pollingPeriodInSeconds = 10;
    private int pollingMaxDurationInSeconds = 300;
    private boolean useProxy = false;
    private int proxyPort = 8888;

    public void setLoadRunnerUser(String loadRunnerUser) {
        this.loadRunnerUser = loadRunnerUser;
    }

    public void setLoadRunnerPassword(String loadRunnerPassword) {
        this.loadRunnerPassword = loadRunnerPassword;
    }

    public void setLoadRunnerTenantId(String loadRunnerTenantId) {
        this.loadRunnerTenantId = loadRunnerTenantId;
    }

    public void setLoadRunnerProjectId(String loadRunnerProjectId) {
        this.loadRunnerProjectId = loadRunnerProjectId;
    }

    public void setLoadRunnerLoadTestId(String loadRunnerLoadTestId) {
        this.loadRunnerLoadTestId = loadRunnerLoadTestId;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setPollingPeriodInSeconds(int pollingPeriodInSeconds) {
        this.pollingPeriodInSeconds = pollingPeriodInSeconds;
    }

    public void setPollingMaxDurationInSeconds(int pollingMaxDurationInSeconds) {
        this.pollingMaxDurationInSeconds = pollingMaxDurationInSeconds;
    }

    public void setLoadRunnerUseTracingHeader(boolean loadRunnerUseTracingHeader) {
        this.loadRunnerUseTracingHeader = loadRunnerUseTracingHeader;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    private LoadRunnerCloudEventContext createLoadRunnerCloudEventContext(EventContext context) {
        Duration pollingPeriod = Duration.ofSeconds(this.pollingPeriodInSeconds);
        Duration pollingMaxDuration = Duration.ofSeconds(this.pollingMaxDurationInSeconds);
        return new LoadRunnerCloudEventContext(context, this.loadRunnerUser, this.loadRunnerPassword, this.loadRunnerTenantId, this.loadRunnerProjectId, this.loadRunnerLoadTestId, this.loadRunnerUseTracingHeader, pollingPeriod, pollingMaxDuration, this.useProxy, this.proxyPort);
    }

    public LoadRunnerCloudEventContext toContext() {
        EventContext context = super.toContext();
        return this.createLoadRunnerCloudEventContext(context);
    }

    public EventContext toContext(TestContext overrideTestContext) {
        return this.createLoadRunnerCloudEventContext(super.toContext(overrideTestContext));
    }
}

