/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event.loadrunner;

import io.perfana.event.loadrunner.LoadRunnerCloudClient;
import io.perfana.event.loadrunner.LoadRunnerCloudClientException;
import io.perfana.event.loadrunner.LoadRunnerCloudEventContext;
import io.perfana.event.loadrunner.api.RunReply;
import io.perfana.event.loadrunner.api.RuntimeAdditionalAttribute;
import io.perfana.event.loadrunner.api.TestRunActive;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.message.EventMessage;
import nl.stokpop.eventscheduler.api.message.EventMessageBus;

public class LoadRunnerCloudEvent
extends EventAdapter<LoadRunnerCloudEventContext> {
    private static final String LOADRUNNER_CLOUD_BASE_URL = "https://loadrunner-cloud.saas.microfocus.com/v1";
    public static final String PERFANA_LRC_PREFIX = "perfana-lrc-";
    public static final String PLUGIN_NAME = LoadRunnerCloudEvent.class.getSimpleName();
    public static final String TRACING_HEADER_NAME = "perfanaTestRunId";
    private volatile LoadRunnerCloudClient client;
    private volatile int runId;

    public LoadRunnerCloudEvent(LoadRunnerCloudEventContext context, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)context, messageBus, logger);
    }

    public void beforeTest() {
        this.logger.info("before test [" + ((LoadRunnerCloudEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
        String user = ((LoadRunnerCloudEventContext)this.eventContext).getLoadRunnerUser();
        String password = ((LoadRunnerCloudEventContext)this.eventContext).getLoadRunnerPassword();
        String tenantId = ((LoadRunnerCloudEventContext)this.eventContext).getLoadRunnerTenantId();
        String projectId = ((LoadRunnerCloudEventContext)this.eventContext).getLoadRunnerProjectId();
        String loadTestId = ((LoadRunnerCloudEventContext)this.eventContext).getLoadRunnerLoadTestId();
        boolean useProxy = ((LoadRunnerCloudEventContext)this.eventContext).isUseProxy();
        this.client = new LoadRunnerCloudClient(LOADRUNNER_CLOUD_BASE_URL, this.logger, useProxy, ((LoadRunnerCloudEventContext)this.eventContext).getProxyPort());
        this.client.initApiKey(user, password, tenantId);
        if (((LoadRunnerCloudEventContext)this.eventContext).isLoadRunnerUseTracingHeader()) {
            this.sendTracingHeader(projectId, loadTestId);
        } else {
            this.logger.info("send tracing header is disabled");
        }
        RunReply runId = this.client.startRun(projectId, loadTestId);
        this.runId = runId.getRunId();
        EventMessage message = EventMessage.builder().pluginName(this.pluginName()).variable("perfana-lrc-tenantId", tenantId).variable("perfana-lrc-projectId", projectId).variable("perfana-lrc-runId", String.valueOf(this.runId)).build();
        this.eventMessageBus.send(message);
        this.logger.info(String.format("started polling if running for projectId: %s loadTestId: %s at %s with runId: %s", projectId, loadTestId, Instant.now(), this.runId));
        Runnable pollForTestRunning = () -> {
            long sleepInMillis = ((LoadRunnerCloudEventContext)this.eventContext).getPollingPeriod().toMillis();
            long maxPollingTimestamp = System.currentTimeMillis() + ((LoadRunnerCloudEventContext)this.eventContext).getPollingMaxDuration().toMillis();
            boolean continuePolling = true;
            while (continuePolling) {
                try {
                    List<TestRunActive> testRunActives = this.client.testRunsActive(projectId);
                    Optional<TestRunActive> testRunActive = testRunActives.stream().filter(t -> t.getRunId() == this.runId).findFirst();
                    if (testRunActive.isPresent()) {
                        TestRunActive testRun = testRunActive.get();
                        this.logger.info(String.format("Status for test id %s (%s) is now: %s", new Object[]{testRun.getTestId(), testRun.getTestName(), testRun.getStatus()}));
                        if (testRun.getStatus() == TestRunActive.Status.RUNNING) {
                            continuePolling = false;
                        }
                    }
                }
                catch (LoadRunnerCloudClientException e) {
                    this.logger.warn("Cannot call test runs active, will retry: " + e.getMessage());
                }
                try {
                    Thread.sleep(sleepInMillis);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Interrupt received, will stop polling now.");
                    continuePolling = false;
                    EventMessage stopMessage = EventMessage.builder().pluginName(this.pluginName()).message("Stop!").build();
                    this.eventMessageBus.send(stopMessage);
                }
                if (System.currentTimeMillis() <= maxPollingTimestamp) continue;
                this.logger.warn("Max polling period reached (" + ((LoadRunnerCloudEventContext)this.eventContext).getPollingMaxDuration() + " seconds), will stop polling now.");
                continuePolling = false;
                EventMessage stopMessage = EventMessage.builder().pluginName(this.pluginName()).message("Stop!").build();
                this.eventMessageBus.send(stopMessage);
            }
            EventMessage goMessage = EventMessage.builder().pluginName(this.pluginName()).message("Go!").build();
            this.eventMessageBus.send(goMessage);
        };
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "LrcPollForTestRunning"));
        executor.execute(pollForTestRunning);
        this.logger.info(String.format("started run with projectId: %s loadTestId: %s at %s with runId: %s. Waiting for status RUNNING.", projectId, loadTestId, Instant.now(), runId.getRunId()));
    }

    private void sendTracingHeader(String projectId, String loadTestId) {
        String testRunId = ((LoadRunnerCloudEventContext)this.eventContext).getTestContext().getTestRunId();
        this.logger.info("send tracing header 'perfanaTestRunId: " + testRunId + "'");
        RuntimeAdditionalAttribute attribute = RuntimeAdditionalAttribute.builder().name(TRACING_HEADER_NAME).value(testRunId).description("Use in web_add_header(\"perfana-test-run-id\", lr_get_attrib_string(\"perfanaTestRunId\"))").build();
        List<RuntimeAdditionalAttribute> attributes = Collections.singletonList(attribute);
        this.client.addAdditionalRuntimeSettingsAttributesForAllScriptsOfTest(projectId, loadTestId, attributes);
    }

    private String pluginName() {
        return PLUGIN_NAME + "-" + ((LoadRunnerCloudEventContext)this.eventContext).getName();
    }

    public void abortTest() {
        this.logger.info("abort test [" + ((LoadRunnerCloudEventContext)this.eventContext).getTestContext().getTestRunId() + "] with runId [" + this.runId + "]");
        this.client.stopRun(this.runId);
    }
}

