/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.testrunner;

import com.lazerycode.jmeter.exceptions.ResultsFileNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultScanner.class);
    private static final String CSV_REQUEST_FAILURE = "\\bfalse\\b";
    private static final String CSV_REQUEST_SUCCESS = "\\btrue\\b";
    private static final String XML_REQUEST_FAILURE = "s=\"false\"";
    private static final String XML_REQUEST_SUCCESS = "s=\"true\"";
    private final boolean countFailures;
    private final boolean countSuccesses;
    private int failureCount = 0;
    private int successCount = 0;
    private boolean csv;

    public ResultScanner(boolean countSuccesses, boolean countFailures, boolean isCsv) {
        this.countFailures = countFailures;
        this.countSuccesses = countSuccesses;
        this.csv = isCsv;
    }

    public ResultScanner(boolean countSuccesses, boolean countFailures) {
        this(countSuccesses, countFailures, false);
    }

    public void parseResultFile(File file) throws ResultsFileNotFoundException {
        String failurePattern = this.csv ? CSV_REQUEST_FAILURE : XML_REQUEST_FAILURE;
        String successPattern = this.csv ? CSV_REQUEST_SUCCESS : XML_REQUEST_SUCCESS;
        LOGGER.info("Parsing results file '{}' in format '{}', using failurePattern:'{}', successPattern:'{}'", new Object[]{file, this.csv ? "CSV" : "XML", failurePattern, successPattern});
        if (this.countFailures) {
            this.failureCount += this.scanFileForPattern(file, failurePattern);
        }
        if (this.countSuccesses) {
            this.successCount += this.scanFileForPattern(file, successPattern);
        }
    }

    private int scanFileForPattern(File file, String pattern) throws ResultsFileNotFoundException {
        int patternCount = 0;
        LOGGER.debug("Scanning file '{}' using pattern '{}'", (Object)file.getAbsolutePath(), (Object)pattern);
        try (Scanner resultFileScanner = new Scanner(file);){
            while (resultFileScanner.findWithinHorizon(pattern, 0) != null) {
                ++patternCount;
            }
        }
        catch (FileNotFoundException ex) {
            throw new ResultsFileNotFoundException("File not found for file:" + file.getAbsolutePath() + ", pattern:" + pattern, ex);
        }
        LOGGER.debug("Scanned file '{}' using pattern '{}', result:'{}'", new Object[]{file.getAbsolutePath(), pattern, patternCount});
        return patternCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public int getSuccessCount() {
        return this.successCount;
    }
}

