/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.configuration.JMeterProcessJVMSettings;
import com.lazerycode.jmeter.configuration.ProxyConfiguration;
import com.lazerycode.jmeter.configuration.RemoteConfiguration;
import com.lazerycode.jmeter.perfana.PerfanaClient;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.joda.time.format.DateTimeFormat;

public abstract class AbstractJMeterMojo
extends AbstractMojo {
    protected static final String LINE_SEPARATOR = "-------------------------------------------------------";
    protected static final String JMETER_ARTIFACT_PREFIX = "ApacheJMeter_";
    protected static final String JMETER_ARTIFACT_NAME = "ApacheJMeter";
    protected static final String JMETER_CONFIG_ARTIFACT_NAME = "ApacheJMeter_config";
    protected static final String JORPHAN_ARTIFACT_NAME = "jorphan";
    protected static final String JMETER_GROUP_ID = "org.apache.jmeter";
    @Parameter
    protected List<String> testFilesIncluded = new ArrayList<String>();
    @Parameter
    protected List<String> testFilesExcluded = new ArrayList<String>();
    @Parameter(defaultValue="${basedir}/src/test/conf")
    protected File confFilesDirectory;
    @Parameter(defaultValue="${basedir}/src/test/jmeter")
    protected File testFilesDirectory;
    @Parameter(defaultValue="true")
    protected boolean testResultsTimestamp;
    @Parameter(defaultValue="false")
    protected boolean appendResultsTimestamp;
    @Parameter
    protected String resultsFileNameDateFormat;
    @Parameter(defaultValue="${project.build.directory}/jmeter/results")
    protected File resultsDirectory;
    @Parameter(defaultValue="true")
    protected boolean generateReports;
    @Parameter(defaultValue="${project.build.directory}/jmeter/reports")
    protected File reportDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/testFiles")
    protected File testFilesBuildDirectory;
    @Parameter(defaultValue="${project.build.directory}/jmeter/logs")
    protected File logsDirectory;
    @Parameter
    protected List<File> customPropertiesFiles = new ArrayList<File>();
    @Parameter
    protected boolean useMavenProxy;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter
    protected ProxyConfiguration proxyConfig;
    @Parameter
    protected RemoteConfiguration remoteConfig;
    @Parameter
    protected JMeterProcessJVMSettings jMeterProcessJVMSettings;
    @Parameter
    protected String overrideRootLogLevel;
    @Parameter(defaultValue="false")
    protected boolean suppressJMeterOutput;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${skipTests}")
    protected boolean skipTests;
    @Parameter(defaultValue="0")
    protected String postTestPauseInSeconds;
    @Parameter(defaultValue="${project.build.directory}/config.json")
    protected String testConfigFile;
    @Parameter(defaultValue="${project.build.directory}/jmeter")
    protected File jmeterDirectory;
    @Parameter(defaultValue="${project.build.directory}")
    protected File projectBuildDirectory;
    @Parameter(defaultValue="UNKNOWN_APPLICATION")
    protected String perfanaApplication;
    @Parameter(defaultValue="UNKNOWN_TEST_TYPE")
    protected String perfanaTestType;
    @Parameter(defaultValue="UNKNOWN_TEST_ENVIRONMENT")
    protected String perfanaTestEnvironment;
    @Parameter(defaultValue="UNKNOWN_TEST_RUN_ID")
    protected String perfanaTestRunId;
    @Parameter(defaultValue="")
    protected String perfanaCIBuildResultsUrl;
    @Parameter(defaultValue="UNKNOWN_PERFANA_URL")
    protected String perfanaUrl;
    @Parameter(defaultValue="UNKNOWN_APPLICATION_RELEASE")
    protected String perfanaApplicationRelease;
    @Parameter(defaultValue="0")
    protected String perfanaRampupTimeInSeconds;
    @Parameter(defaultValue="120")
    protected String perfanaConstantLoadTimeInSeconds;
    @Parameter(defaultValue="false")
    protected boolean perfanaAssertResultsEnabled;
    @Parameter(defaultValue="false")
    protected boolean perfanaEnabled;
    @Parameter(defaultValue="")
    protected String perfanaAnnotations;
    @Parameter(defaultValue="")
    protected Properties perfanaVariables;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            if (this.session.getGoals().contains("jmeter:gui")) {
                if (!"default-cli".equals(this.mojoExecution.getExecutionId()) && !"compile".equals(this.mojoExecution.getLifecyclePhase())) {
                    this.getLog().info((CharSequence)"Performance tests are skipped.");
                    return;
                }
            } else {
                this.getLog().info((CharSequence)"Performance tests are skipped.");
                return;
            }
        }
        if (this.useMavenProxy && this.proxyConfig == null) {
            this.loadMavenProxy();
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected JMeterArgumentsArray computeJMeterArgumentsArray(boolean disableGUI, boolean isCSVFormat) throws MojoExecutionException {
        JMeterArgumentsArray testArgs = new JMeterArgumentsArray(disableGUI, this.jmeterDirectory.getAbsolutePath());
        testArgs.setResultsDirectory(this.resultsDirectory.getAbsolutePath());
        testArgs.setResultFileOutputFormatIsCSV(isCSVFormat);
        if (this.generateReports && disableGUI) {
            testArgs.setReportsDirectory(this.reportDirectory.getAbsolutePath());
        }
        if (this.testResultsTimestamp) {
            testArgs.setResultsTimestamp(true);
            testArgs.appendTimestamp(this.appendResultsTimestamp);
            if (UtilityFunctions.isSet(this.resultsFileNameDateFormat).booleanValue()) {
                try {
                    testArgs.setResultsFileNameDateFormat(DateTimeFormat.forPattern((String)this.resultsFileNameDateFormat));
                }
                catch (Exception ex) {
                    this.getLog().error((CharSequence)("'" + this.resultsFileNameDateFormat + "' is an invalid DateTimeFormat.  Defaulting to Standard ISO_8601."), (Throwable)ex);
                }
            }
        }
        testArgs.setProxyConfig(this.proxyConfig);
        for (File customPropertiesFile : this.customPropertiesFiles) {
            testArgs.setACustomPropertiesFile(customPropertiesFile);
        }
        testArgs.setLogRootOverride(this.overrideRootLogLevel);
        testArgs.setLogsDirectory(this.logsDirectory.getAbsolutePath());
        return testArgs;
    }

    protected void loadMavenProxy() {
        if (this.settings == null) {
            return;
        }
        try {
            Proxy mvnProxy = this.settings.getActiveProxy();
            if (mvnProxy != null) {
                ProxyConfiguration newProxyConf = new ProxyConfiguration();
                newProxyConf.setHost(mvnProxy.getHost());
                newProxyConf.setPort(mvnProxy.getPort());
                newProxyConf.setUsername(mvnProxy.getUsername());
                newProxyConf.setPassword(mvnProxy.getPassword());
                newProxyConf.setHostExclusions(mvnProxy.getNonProxyHosts());
                this.proxyConfig = newProxyConf;
                this.getLog().info((CharSequence)"Maven proxy loaded successfully");
            } else {
                this.getLog().warn((CharSequence)"No maven proxy found, but useMavenProxy set to true.");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while loading maven proxy", (Throwable)e);
        }
    }

    static void copyFilesInTestDirectory(File sourceDirectory, File destinationDirectory) throws com.lazerycode.jmeter.exceptions.IOException {
        try {
            FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory);
        }
        catch (IOException e) {
            throw new com.lazerycode.jmeter.exceptions.IOException(e.getMessage(), e);
        }
    }

    protected PerfanaClient createPerfanaClient() {
        PerfanaClient client = new PerfanaClient(this.perfanaApplication, this.perfanaTestType, this.perfanaTestEnvironment, this.perfanaTestRunId, this.perfanaCIBuildResultsUrl, this.perfanaApplicationRelease, this.perfanaRampupTimeInSeconds, this.perfanaConstantLoadTimeInSeconds, this.perfanaUrl, this.perfanaAnnotations, this.perfanaVariables, this.perfanaAssertResultsEnabled);
        client.injectLogger(new PerfanaClient.Logger(){

            @Override
            public void info(String message) {
                AbstractJMeterMojo.this.getLog().info((CharSequence)message);
            }

            @Override
            public void warn(String message) {
                AbstractJMeterMojo.this.getLog().warn((CharSequence)message);
            }

            @Override
            public void error(String message) {
                AbstractJMeterMojo.this.getLog().error((CharSequence)message);
            }

            @Override
            public void debug(String message) {
                AbstractJMeterMojo.this.getLog().debug((CharSequence)message);
            }
        });
        return client;
    }
}

