/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.PerfanaClient;
import io.perfana.client.PerfanaUtils;
import io.perfana.client.api.PerfanaTestContext;
import io.perfana.event.PerfanaEventContext;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.TestContextInitializer;
import io.perfana.eventscheduler.api.config.TestContext;

public class PerfanaTestContextInitializer
implements TestContextInitializer {
    private final PerfanaEventContext perfanaEventContext;
    private final EventLogger logger;

    PerfanaTestContextInitializer(PerfanaEventContext context, EventLogger logger) {
        this.perfanaEventContext = context;
        this.logger = logger;
    }

    public TestContext extendTestContext(TestContext testContext) {
        if (!this.perfanaEventContext.isOverrideTestRunId()) {
            this.logger.info("Perfana test run id override is disabled. No override will be done.");
            return testContext;
        }
        PerfanaTestContext perfanaTestContext = PerfanaUtils.createPerfanaTestContext(this.perfanaEventContext, testContext);
        PerfanaClient perfanaClient = PerfanaUtils.createPerfanaClient(this.perfanaEventContext, perfanaTestContext, this.logger);
        String newTestRunId = perfanaClient.callInitTest(perfanaTestContext);
        if (newTestRunId == null) {
            this.logger.warn("Perfana test run id is null. No override will be done.");
            return testContext;
        }
        this.logger.info("Perfana test run id is '" + newTestRunId + "'. Will override test run id. ");
        return testContext.withTestRunId(newTestRunId);
    }
}

