/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.event.PerfanaEventContext;
import io.perfana.eventscheduler.api.config.EventConfig;
import io.perfana.eventscheduler.api.config.EventContext;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PerfanaEventConfig
extends EventConfig {
    private String perfanaUrl = "http://localhost:4000";
    private String apiKey = null;
    private boolean assertResultsEnabled = false;
    private Map<String, String> variables = Collections.emptyMap();
    private int retryCount = 30;
    private int retryDelaySeconds = 6;
    private boolean overrideTestRunId = true;

    public void setPerfanaUrl(String perfanaUrl) {
        this.perfanaUrl = perfanaUrl;
    }

    public void setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryDelaySeconds(int retryDelaySeconds) {
        this.retryDelaySeconds = retryDelaySeconds;
    }

    @NotNull
    private PerfanaEventContext createPerfanaEventContext(EventContext context) {
        return new PerfanaEventContext(context, this.perfanaUrl, this.apiKey, this.assertResultsEnabled, this.variables, this.retryCount, this.retryDelaySeconds, this.overrideTestRunId);
    }

    public void setOverrideTestRunId(boolean overrideTestRunId) {
        this.overrideTestRunId = overrideTestRunId;
    }

    public PerfanaEventContext toContext() {
        return this.createPerfanaEventContext(super.toContext());
    }

    public String toString() {
        return "PerfanaEventConfig{perfanaUrl='" + this.perfanaUrl + "', apiKey=" + (this.apiKey == null ? "[not set]" : "[set]") + ", assertResultsEnabled=" + this.assertResultsEnabled + ", variables=" + this.variables + ", retryCount=" + this.retryCount + ", retryDelaySeconds=" + this.retryDelaySeconds + "}" + super.toString();
    }
}

