/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.PerfanaClient;
import io.perfana.client.PerfanaUtils;
import io.perfana.client.api.PerfanaTestContext;
import io.perfana.client.domain.ConfigItem;
import io.perfana.client.domain.TestRunConfigJson;
import io.perfana.client.domain.TestRunConfigKeyValue;
import io.perfana.client.domain.TestRunConfigKeys;
import io.perfana.client.exception.PerfanaAssertResultsException;
import io.perfana.client.exception.PerfanaAssertionsAreFalse;
import io.perfana.client.exception.PerfanaClientException;
import io.perfana.event.PerfanaEventContext;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventAdapter;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.EventStatus;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.api.message.EventMessage;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.api.message.EventMessageReceiver;
import io.perfana.eventscheduler.exception.handler.KillSwitchException;
import io.perfana.eventscheduler.util.TestRunConfigUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerfanaEvent
extends EventAdapter<PerfanaEventContext> {
    private static final String CLASSNAME = PerfanaEvent.class.getName();
    public static final String PLUGIN_NAME = "perfana-java-client";
    private final String eventName;
    private final PerfanaTestContext perfanaTestContext;
    private final EventMessageBus messageBus;
    private final Map<String, String> receivedVariables = new ConcurrentHashMap<String, String>();
    private final PerfanaClient perfanaClient;
    private String abortDetailMessage = null;
    private EventCheck eventCheck;

    PerfanaEvent(PerfanaEventContext context, TestContext testContext, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)context, testContext, messageBus, logger);
        this.eventCheck = new EventCheck(context.getName(), CLASSNAME, EventStatus.UNKNOWN, "No known result yet. Try again some time later.");
        this.eventName = context.getName();
        this.perfanaTestContext = PerfanaUtils.createPerfanaTestContext(context, testContext);
        this.messageBus = messageBus;
        this.perfanaClient = PerfanaUtils.createPerfanaClient(context, this.perfanaTestContext, logger);
        EventMessageReceiver eventMessageReceiver = message -> {
            if (message.getVariables().getOrDefault("message-type", "").equals("test-run-config")) {
                logger.debug("received test-run-config message from " + message.getPluginName());
                this.addTestRunConfig(message);
            } else if (!message.getVariables().isEmpty()) {
                logger.debug("received variables from " + message.getPluginName() + ": " + message.getVariables());
                this.receivedVariables.putAll(message.getVariables());
            }
        };
        this.messageBus.addReceiver(eventMessageReceiver);
    }

    private void addTestRunConfig(EventMessage message) {
        Map variables = message.getVariables();
        String output = (String)variables.get("output");
        String tags = variables.getOrDefault("tags", "");
        switch (output) {
            case "key": {
                TestRunConfigKeyValue.TestRunConfigKeyValueBuilder testRunConfig = TestRunConfigKeyValue.builder().testRunId(this.perfanaTestContext.getTestRunId()).application(this.perfanaTestContext.getSystemUnderTest()).testEnvironment(this.perfanaTestContext.getTestEnvironment()).testType(this.perfanaTestContext.getWorkload()).key((String)variables.get("key")).value(this.replaceNullWithEmptyString(message.getMessage()));
                Arrays.stream(tags.split(",")).forEach(testRunConfig::tag);
                this.perfanaClient.addTestRunConfigKeyValue(testRunConfig.build());
                break;
            }
            case "json": {
                TestRunConfigJson.TestRunConfigJsonBuilder testRunConfigJson = TestRunConfigJson.builder().testRunId(this.perfanaTestContext.getTestRunId()).application(this.perfanaTestContext.getSystemUnderTest()).testEnvironment(this.perfanaTestContext.getTestEnvironment()).testType(this.perfanaTestContext.getWorkload()).json(message.getMessage());
                String excludes = variables.getOrDefault("excludes", "");
                String includes = variables.getOrDefault("includes", "");
                Arrays.stream(excludes.split(",")).forEach(testRunConfigJson::excludeItem);
                Arrays.stream(includes.split(",")).forEach(testRunConfigJson::includeItem);
                Arrays.stream(tags.split(",")).forEach(testRunConfigJson::tag);
                this.perfanaClient.addTestRunConfigJson(testRunConfigJson.build());
                break;
            }
            case "keys": {
                TestRunConfigKeys.TestRunConfigKeysBuilder keysBuilder = TestRunConfigKeys.builder().testRunId(this.perfanaTestContext.getTestRunId()).application(this.perfanaTestContext.getSystemUnderTest()).testEnvironment(this.perfanaTestContext.getTestEnvironment()).testType(this.perfanaTestContext.getWorkload());
                Arrays.stream(tags.split(",")).forEach(keysBuilder::tag);
                String keyValuePairsString = message.getMessage();
                List<String> keyValuePairs = Arrays.asList(keyValuePairsString.split("\u0000", -1));
                if (keyValuePairs.size() % 2 != 0) {
                    this.logger.error("skip send of test config key value pairs: received string with uneven number of key-value items: " + keyValuePairs.size());
                    break;
                }
                for (int i = 0; i < keyValuePairs.size(); i += 2) {
                    keysBuilder.configItem(new ConfigItem(keyValuePairs.get(i), keyValuePairs.get(i + 1)));
                }
                this.perfanaClient.addTestRunConfigKeys(keysBuilder.build());
                break;
            }
            default: {
                this.logger.error("received test-run-config message with unexpected output type: " + output);
            }
        }
    }

    private String replaceNullWithEmptyString(String text) {
        return text == null ? "" : text;
    }

    public void beforeTest() {
        this.sendTestRunConfig();
    }

    private void sendTestRunConfig() {
        Map<String, String> configKeyValues = this.createTestRunConfigKeyValues();
        EventMessage message = TestRunConfigUtil.createTestRunConfigMessageKeys((String)((PerfanaEventContext)this.eventContext).getName(), configKeyValues, (String)PLUGIN_NAME);
        this.eventMessageBus.send(message);
    }

    private Map<String, String> createTestRunConfigKeyValues() {
        String prefix = "event." + ((PerfanaEventContext)this.eventContext).getName() + ".";
        HashMap<String, String> lines = new HashMap<String, String>();
        lines.put(prefix + "perfanaUrl", ((PerfanaEventContext)this.eventContext).getPerfanaUrl());
        lines.put(prefix + "isAssertResultsEnabled", String.valueOf(((PerfanaEventContext)this.eventContext).isAssertResultsEnabled()));
        lines.put(prefix + "scheduleScript", ((PerfanaEventContext)this.eventContext).getScheduleScript());
        lines.put(prefix + "variables", String.valueOf(((PerfanaEventContext)this.eventContext).getVariables()));
        return lines;
    }

    public void startTest() {
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test start", "Test run started");
    }

    public void afterTest() {
        if (this.abortDetailMessage != null) {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test abort", this.abortDetailMessage);
        } else {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test end", "Test run completed");
        }
        this.finalizePerfanaTestRun();
    }

    private void finalizePerfanaTestRun() {
        this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, true, this.receivedVariables);
        this.eventCheck = new EventCheck(this.eventName, CLASSNAME, EventStatus.SUCCESS, "All ok!");
        try {
            String text = this.perfanaClient.assertResults();
            this.logger.info("Received Perfana check results: " + text);
        }
        catch (PerfanaAssertResultsException e) {
            this.logger.error("Perfana check results failed: " + e.getMessage());
            this.eventCheck = new EventCheck(this.eventName, CLASSNAME, EventStatus.FAILURE, "Perfana check results failed: " + e.getMessage());
        }
        catch (PerfanaClientException e) {
            this.logger.error("Perfana check results failed.", (Throwable)e);
            this.eventCheck = new EventCheck(this.eventName, CLASSNAME, EventStatus.FAILURE, "Failed to get check results: " + e.getMessage());
        }
        catch (PerfanaAssertionsAreFalse perfanaAssertionsAreFalse) {
            this.eventCheck = new EventCheck(this.eventName, CLASSNAME, EventStatus.FAILURE, perfanaAssertionsAreFalse.getMessage());
        }
    }

    public void abortTest() {
        String eventTitle = "Test aborted";
        String eventDescription = this.abortDetailMessage == null ? "manually aborted" : this.abortDetailMessage;
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, eventTitle, eventDescription);
        this.eventCheck = new EventCheck(this.eventName, CLASSNAME, EventStatus.ABORTED, eventDescription);
        this.finalizePerfanaTestRun();
    }

    public EventCheck check() {
        return this.eventCheck;
    }

    public void keepAlive() {
        this.logger.debug("Keep alive called");
        try {
            this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, false, this.receivedVariables);
        }
        catch (KillSwitchException killSwitchException) {
            this.abortDetailMessage = killSwitchException.getMessage();
            throw killSwitchException;
        }
    }

    public void customEvent(CustomEvent customEvent) {
        try {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, customEvent.getName(), customEvent.getDescription());
        }
        catch (Exception e) {
            this.logger.error("Perfana call event failed", (Throwable)e);
        }
    }
}

