/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import io.perfana.client.PerfanaClient;
import io.perfana.client.api.PerfanaClientLogger;
import io.perfana.client.api.PerfanaClientLoggerStdOut;
import io.perfana.client.api.PerfanaConnectionSettings;
import io.perfana.client.api.PerfanaTestContext;
import io.perfana.client.exception.PerfanaClientRuntimeException;

public class PerfanaClientBuilder {
    private PerfanaTestContext testContext;
    private PerfanaConnectionSettings perfanaConnectionSettings;
    private boolean assertResultsEnabled = true;
    private PerfanaClientLogger logger = new PerfanaClientLoggerStdOut();

    public PerfanaClientBuilder setTestContext(PerfanaTestContext context) {
        this.testContext = context;
        return this;
    }

    public PerfanaClientBuilder setLogger(PerfanaClientLogger logger) {
        this.logger = logger;
        return this;
    }

    public PerfanaClientBuilder setPerfanaConnectionSettings(PerfanaConnectionSettings settings) {
        this.perfanaConnectionSettings = settings;
        return this;
    }

    public PerfanaClientBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public PerfanaClient build() {
        if (this.testContext == null) {
            throw new PerfanaClientRuntimeException("TestContext must be set, it is null.");
        }
        if (this.perfanaConnectionSettings == null) {
            throw new PerfanaClientRuntimeException("PerfanaConnectionSettings must be set, it is null.");
        }
        return new PerfanaClient(this.testContext, this.perfanaConnectionSettings, this.assertResultsEnabled, this.logger);
    }
}

