/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import io.perfana.client.domain.ConfigItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TestRunConfigKeys {
    private final String application;
    private final String testEnvironment;
    private final String testType;
    private final String testRunId;
    private final List<String> tags;
    private final List<ConfigItem> configItems;

    public static TestRunConfigKeysBuilder builder() {
        return new TestRunConfigKeysBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getTestType() {
        return this.testType;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<ConfigItem> getConfigItems() {
        return this.configItems;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRunConfigKeys)) {
            return false;
        }
        TestRunConfigKeys other = (TestRunConfigKeys)o;
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$testType = this.getTestType();
        String other$testType = other.getTestType();
        if (this$testType == null ? other$testType != null : !this$testType.equals(other$testType)) {
            return false;
        }
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<ConfigItem> this$configItems = this.getConfigItems();
        List<ConfigItem> other$configItems = other.getConfigItems();
        return !(this$configItems == null ? other$configItems != null : !((Object)this$configItems).equals(other$configItems));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $testType = this.getTestType();
        result = result * 59 + ($testType == null ? 43 : $testType.hashCode());
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<ConfigItem> $configItems = this.getConfigItems();
        result = result * 59 + ($configItems == null ? 43 : ((Object)$configItems).hashCode());
        return result;
    }

    public String toString() {
        return "TestRunConfigKeys(application=" + this.getApplication() + ", testEnvironment=" + this.getTestEnvironment() + ", testType=" + this.getTestType() + ", testRunId=" + this.getTestRunId() + ", tags=" + this.getTags() + ", configItems=" + this.getConfigItems() + ")";
    }

    private TestRunConfigKeys() {
        this.application = null;
        this.testEnvironment = null;
        this.testType = null;
        this.testRunId = null;
        this.tags = null;
        this.configItems = null;
    }

    public TestRunConfigKeys(String application, String testEnvironment, String testType, String testRunId, List<String> tags, List<ConfigItem> configItems) {
        this.application = application;
        this.testEnvironment = testEnvironment;
        this.testType = testType;
        this.testRunId = testRunId;
        this.tags = tags;
        this.configItems = configItems;
    }

    public static class TestRunConfigKeysBuilder {
        private String application;
        private String testEnvironment;
        private String testType;
        private String testRunId;
        private ArrayList<String> tags;
        private ArrayList<ConfigItem> configItems;

        TestRunConfigKeysBuilder() {
        }

        public TestRunConfigKeysBuilder application(String application) {
            this.application = application;
            return this;
        }

        public TestRunConfigKeysBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public TestRunConfigKeysBuilder testType(String testType) {
            this.testType = testType;
            return this;
        }

        public TestRunConfigKeysBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public TestRunConfigKeysBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public TestRunConfigKeysBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public TestRunConfigKeysBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public TestRunConfigKeysBuilder configItem(ConfigItem configItem) {
            if (this.configItems == null) {
                this.configItems = new ArrayList();
            }
            this.configItems.add(configItem);
            return this;
        }

        public TestRunConfigKeysBuilder configItems(Collection<? extends ConfigItem> configItems) {
            if (configItems == null) {
                throw new NullPointerException("configItems cannot be null");
            }
            if (this.configItems == null) {
                this.configItems = new ArrayList();
            }
            this.configItems.addAll(configItems);
            return this;
        }

        public TestRunConfigKeysBuilder clearConfigItems() {
            if (this.configItems != null) {
                this.configItems.clear();
            }
            return this;
        }

        public TestRunConfigKeys build() {
            List<ConfigItem> configItems;
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            switch (this.configItems == null ? 0 : this.configItems.size()) {
                case 0: {
                    configItems = Collections.emptyList();
                    break;
                }
                case 1: {
                    configItems = Collections.singletonList(this.configItems.get(0));
                    break;
                }
                default: {
                    configItems = Collections.unmodifiableList(new ArrayList<ConfigItem>(this.configItems));
                }
            }
            return new TestRunConfigKeys(this.application, this.testEnvironment, this.testType, this.testRunId, tags, configItems);
        }

        public String toString() {
            return "TestRunConfigKeys.TestRunConfigKeysBuilder(application=" + this.application + ", testEnvironment=" + this.testEnvironment + ", testType=" + this.testType + ", testRunId=" + this.testRunId + ", tags=" + this.tags + ", configItems=" + this.configItems + ")";
        }
    }
}

