/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TestRunConfigKeyValue {
    private final String application;
    private final String testEnvironment;
    private final String testType;
    private final String testRunId;
    private final List<String> tags;
    private final String key;
    private final String value;

    public static TestRunConfigKeyValueBuilder builder() {
        return new TestRunConfigKeyValueBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getTestType() {
        return this.testType;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRunConfigKeyValue)) {
            return false;
        }
        TestRunConfigKeyValue other = (TestRunConfigKeyValue)o;
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$testType = this.getTestType();
        String other$testType = other.getTestType();
        if (this$testType == null ? other$testType != null : !this$testType.equals(other$testType)) {
            return false;
        }
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $testType = this.getTestType();
        result = result * 59 + ($testType == null ? 43 : $testType.hashCode());
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "TestRunConfigKeyValue(application=" + this.getApplication() + ", testEnvironment=" + this.getTestEnvironment() + ", testType=" + this.getTestType() + ", testRunId=" + this.getTestRunId() + ", tags=" + this.getTags() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    private TestRunConfigKeyValue() {
        this.application = null;
        this.testEnvironment = null;
        this.testType = null;
        this.testRunId = null;
        this.tags = null;
        this.key = null;
        this.value = null;
    }

    public TestRunConfigKeyValue(String application, String testEnvironment, String testType, String testRunId, List<String> tags, String key, String value) {
        this.application = application;
        this.testEnvironment = testEnvironment;
        this.testType = testType;
        this.testRunId = testRunId;
        this.tags = tags;
        this.key = key;
        this.value = value;
    }

    public static class TestRunConfigKeyValueBuilder {
        private String application;
        private String testEnvironment;
        private String testType;
        private String testRunId;
        private ArrayList<String> tags;
        private String key;
        private String value;

        TestRunConfigKeyValueBuilder() {
        }

        public TestRunConfigKeyValueBuilder application(String application) {
            this.application = application;
            return this;
        }

        public TestRunConfigKeyValueBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public TestRunConfigKeyValueBuilder testType(String testType) {
            this.testType = testType;
            return this;
        }

        public TestRunConfigKeyValueBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public TestRunConfigKeyValueBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public TestRunConfigKeyValueBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public TestRunConfigKeyValueBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public TestRunConfigKeyValueBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TestRunConfigKeyValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TestRunConfigKeyValue build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new TestRunConfigKeyValue(this.application, this.testEnvironment, this.testType, this.testRunId, tags, this.key, this.value);
        }

        public String toString() {
            return "TestRunConfigKeyValue.TestRunConfigKeyValueBuilder(application=" + this.application + ", testEnvironment=" + this.testEnvironment + ", testType=" + this.testType + ", testRunId=" + this.testRunId + ", tags=" + this.tags + ", key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

