/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import com.fasterxml.jackson.annotation.JsonRawValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TestRunConfigJson {
    private final String application;
    private final String testEnvironment;
    private final String testType;
    private final String testRunId;
    private final List<String> tags;
    private final List<String> include;
    private final List<String> exclude;
    @JsonRawValue
    private final String json;

    public static TestRunConfigJsonBuilder builder() {
        return new TestRunConfigJsonBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getTestType() {
        return this.testType;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public String getJson() {
        return this.json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRunConfigJson)) {
            return false;
        }
        TestRunConfigJson other = (TestRunConfigJson)o;
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$testType = this.getTestType();
        String other$testType = other.getTestType();
        if (this$testType == null ? other$testType != null : !this$testType.equals(other$testType)) {
            return false;
        }
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$include = this.getInclude();
        List<String> other$include = other.getInclude();
        if (this$include == null ? other$include != null : !((Object)this$include).equals(other$include)) {
            return false;
        }
        List<String> this$exclude = this.getExclude();
        List<String> other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $testType = this.getTestType();
        result = result * 59 + ($testType == null ? 43 : $testType.hashCode());
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        List<String> $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }

    public String toString() {
        return "TestRunConfigJson(application=" + this.getApplication() + ", testEnvironment=" + this.getTestEnvironment() + ", testType=" + this.getTestType() + ", testRunId=" + this.getTestRunId() + ", tags=" + this.getTags() + ", include=" + this.getInclude() + ", exclude=" + this.getExclude() + ", json=" + this.getJson() + ")";
    }

    private TestRunConfigJson() {
        this.application = null;
        this.testEnvironment = null;
        this.testType = null;
        this.testRunId = null;
        this.tags = null;
        this.include = null;
        this.exclude = null;
        this.json = null;
    }

    public TestRunConfigJson(String application, String testEnvironment, String testType, String testRunId, List<String> tags, List<String> include, List<String> exclude, String json) {
        this.application = application;
        this.testEnvironment = testEnvironment;
        this.testType = testType;
        this.testRunId = testRunId;
        this.tags = tags;
        this.include = include;
        this.exclude = exclude;
        this.json = json;
    }

    public static class TestRunConfigJsonBuilder {
        private String application;
        private String testEnvironment;
        private String testType;
        private String testRunId;
        private ArrayList<String> tags;
        private ArrayList<String> include;
        private ArrayList<String> exclude;
        private String json;

        TestRunConfigJsonBuilder() {
        }

        public TestRunConfigJsonBuilder application(String application) {
            this.application = application;
            return this;
        }

        public TestRunConfigJsonBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public TestRunConfigJsonBuilder testType(String testType) {
            this.testType = testType;
            return this;
        }

        public TestRunConfigJsonBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public TestRunConfigJsonBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public TestRunConfigJsonBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public TestRunConfigJsonBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public TestRunConfigJsonBuilder includeItem(String includeItem) {
            if (this.include == null) {
                this.include = new ArrayList();
            }
            this.include.add(includeItem);
            return this;
        }

        public TestRunConfigJsonBuilder include(Collection<? extends String> include) {
            if (include == null) {
                throw new NullPointerException("include cannot be null");
            }
            if (this.include == null) {
                this.include = new ArrayList();
            }
            this.include.addAll(include);
            return this;
        }

        public TestRunConfigJsonBuilder clearInclude() {
            if (this.include != null) {
                this.include.clear();
            }
            return this;
        }

        public TestRunConfigJsonBuilder excludeItem(String excludeItem) {
            if (this.exclude == null) {
                this.exclude = new ArrayList();
            }
            this.exclude.add(excludeItem);
            return this;
        }

        public TestRunConfigJsonBuilder exclude(Collection<? extends String> exclude) {
            if (exclude == null) {
                throw new NullPointerException("exclude cannot be null");
            }
            if (this.exclude == null) {
                this.exclude = new ArrayList();
            }
            this.exclude.addAll(exclude);
            return this;
        }

        public TestRunConfigJsonBuilder clearExclude() {
            if (this.exclude != null) {
                this.exclude.clear();
            }
            return this;
        }

        public TestRunConfigJsonBuilder json(String json) {
            this.json = json;
            return this;
        }

        public TestRunConfigJson build() {
            List<String> exclude;
            List<String> include;
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            switch (this.include == null ? 0 : this.include.size()) {
                case 0: {
                    include = Collections.emptyList();
                    break;
                }
                case 1: {
                    include = Collections.singletonList(this.include.get(0));
                    break;
                }
                default: {
                    include = Collections.unmodifiableList(new ArrayList<String>(this.include));
                }
            }
            switch (this.exclude == null ? 0 : this.exclude.size()) {
                case 0: {
                    exclude = Collections.emptyList();
                    break;
                }
                case 1: {
                    exclude = Collections.singletonList(this.exclude.get(0));
                    break;
                }
                default: {
                    exclude = Collections.unmodifiableList(new ArrayList<String>(this.exclude));
                }
            }
            return new TestRunConfigJson(this.application, this.testEnvironment, this.testType, this.testRunId, tags, include, exclude, this.json);
        }

        public String toString() {
            return "TestRunConfigJson.TestRunConfigJsonBuilder(application=" + this.application + ", testEnvironment=" + this.testEnvironment + ", testType=" + this.testType + ", testRunId=" + this.testRunId + ", tags=" + this.tags + ", include=" + this.include + ", exclude=" + this.exclude + ", json=" + this.json + ")";
        }
    }
}

