/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import io.perfana.client.domain.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Alert {
    private final String message;
    private final String timestamp;
    private final List<Tag> tags;

    public static AlertBuilder builder() {
        return new AlertBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)o;
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Alert(message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ", tags=" + this.getTags() + ")";
    }

    private Alert() {
        this.message = null;
        this.timestamp = null;
        this.tags = null;
    }

    public Alert(String message, String timestamp, List<Tag> tags) {
        this.message = message;
        this.timestamp = timestamp;
        this.tags = tags;
    }

    public static class AlertBuilder {
        private String message;
        private String timestamp;
        private ArrayList<Tag> tags;

        AlertBuilder() {
        }

        public AlertBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AlertBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AlertBuilder tag(Tag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public AlertBuilder tags(Collection<? extends Tag> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public AlertBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public Alert build() {
            List<Tag> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<Tag>(this.tags));
                }
            }
            return new Alert(this.message, this.timestamp, tags);
        }

        public String toString() {
            return "Alert.AlertBuilder(message=" + this.message + ", timestamp=" + this.timestamp + ", tags=" + this.tags + ")";
        }
    }
}

