/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.perfana.client.PerfanaUtils;
import io.perfana.client.api.PerfanaCaller;
import io.perfana.client.api.PerfanaClientLogger;
import io.perfana.client.api.PerfanaConnectionSettings;
import io.perfana.client.api.TestContext;
import io.perfana.client.domain.Benchmark;
import io.perfana.client.domain.PerfanaErrorMessage;
import io.perfana.client.domain.PerfanaEvent;
import io.perfana.client.domain.PerfanaMessage;
import io.perfana.client.domain.PerfanaTest;
import io.perfana.client.domain.Result;
import io.perfana.client.domain.TestRunConfigJson;
import io.perfana.client.domain.TestRunConfigKeyValue;
import io.perfana.client.domain.TestRunConfigKeys;
import io.perfana.client.domain.Variable;
import io.perfana.client.exception.PerfanaAssertResultsException;
import io.perfana.client.exception.PerfanaAssertionsAreFalse;
import io.perfana.client.exception.PerfanaClientException;
import io.perfana.client.exception.PerfanaClientRuntimeException;
import io.perfana.eventscheduler.exception.handler.AbortSchedulerException;
import io.perfana.eventscheduler.exception.handler.KillSwitchException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerfanaClient
implements PerfanaCaller {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final PerfanaErrorMessage PERFANA_ERROR_MESSAGE_NOT_FOUND = new PerfanaErrorMessage("<No detail message was send>");
    private final OkHttpClient client = new OkHttpClient();
    private final PerfanaClientLogger logger;
    private final TestContext context;
    private final PerfanaConnectionSettings settings;
    private final boolean assertResultsEnabled;
    private static final ObjectReader perfanaBenchmarkReader;
    private static final ObjectReader errorMessageReader;
    private static final ObjectReader perfanaTestReader;
    private static final ObjectWriter perfanaMessageWriter;
    private static final ObjectWriter perfanaEventWriter;
    private static final ObjectWriter testRunConfigKeyValueWriter;
    private static final ObjectWriter testRunConfigJsonWriter;
    private static final ObjectWriter testRunConfigKeysWriter;

    PerfanaClient(TestContext context, PerfanaConnectionSettings settings, boolean assertResultsEnabled, PerfanaClientLogger logger) {
        this.context = context;
        this.settings = settings;
        this.assertResultsEnabled = assertResultsEnabled;
        this.logger = logger;
    }

    @Override
    public void callPerfanaTestEndpoint(TestContext context, boolean completed) throws KillSwitchException {
        this.callPerfanaTestEndpoint(context, completed, Collections.emptyMap());
    }

    @Override
    public void callPerfanaTestEndpoint(TestContext context, boolean completed, Map<String, String> extraVariables) throws KillSwitchException {
        String json = PerfanaClient.perfanaMessageToJson(context, completed, extraVariables);
        Request request = this.createRequest("/api/test", json);
        try (Response response = this.client.newCall(request).execute();){
            this.logger.debug("test endpoint result: " + response);
            int code = response.code();
            String body = this.extractBodyAsString(response.body());
            if (code == 401) {
                String dueTo = this.extractDueTo(response.header("WWW-Authenticate"));
                throw new AbortSchedulerException(String.format("Abort: not authorized (%d) for [%s]%s", code, request, dueTo));
            }
            if (code == 503 || code == 502) {
                this.logger.warn(String.format("Perfana replied with service unavailable (%d) for [%s]. Will retry.", code, request));
            } else {
                if (code == 400 || code == 500) {
                    PerfanaErrorMessage message = this.extractPerfanaErrorMessage(body);
                    if (body != null) {
                        throw new AbortSchedulerException("Abort due to: " + message.getMessage());
                    }
                    this.logger.error(String.format("No response body in test endpoint result: %s", response));
                    throw new AbortSchedulerException(String.format("Abort due to Perfana error reply (%d) for [%s]", code, request));
                }
                if (body != null) {
                    PerfanaTest test;
                    if (!completed && (test = (PerfanaTest)perfanaTestReader.readValue(body)).isAbort()) {
                        String message = test.getAbortMessage();
                        this.logger.info(String.format("abort requested by Perfana! Reason: '%s'", message));
                        throw new KillSwitchException(message);
                    }
                } else {
                    this.logger.error(String.format("No response body in test endpoint result: %s", response));
                }
            }
        }
        catch (IOException e) {
            this.logger.error(String.format("Failed to call Perfana test endpoint: %s", e.getMessage()));
        }
    }

    @NotNull
    private Request createRequest(String endPoint) {
        return this.createRequest(endPoint, null);
    }

    private Request createRequest(@NotNull String endpoint, String json) {
        this.logger.debug("call to endpoint: " + endpoint + (json != null ? " with json: " + json : ""));
        String url = PerfanaUtils.addSlashIfNeeded(this.settings.getPerfanaUrl(), endpoint);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (json == null) {
            requestBuilder.get();
        } else {
            RequestBody body = RequestBody.create((String)json, (MediaType)JSON);
            requestBuilder.post(body);
        }
        if (this.settings.getApiKey() != null) {
            requestBuilder.addHeader("Authorization", "Bearer " + this.settings.getApiKey());
        }
        return requestBuilder.build();
    }

    @Override
    public void callPerfanaEvent(TestContext context, String eventTitle, String eventDescription) {
        this.logger.info("add Perfana event: " + eventDescription);
        String json = this.perfanaEventToJson(context, eventTitle, eventDescription);
        try {
            String result = this.post("/api/events", json);
            this.logger.debug("result: " + result);
        }
        catch (IOException e) {
            this.logger.error("failed to call Perfana event endpoint: " + e.getMessage());
        }
    }

    private String post(String endpoint, String json) throws IOException {
        Request request = this.createRequest(endpoint, json);
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            int responseCode = response.code();
            if (responseCode == 401) {
                this.logger.warn("ignoring: not authorised (401) to post to [" + endpoint + "]");
            }
            if (!response.isSuccessful()) {
                this.logger.warn("POST was not successful. Response: " + response + " Body: " + json);
            }
            String string = responseBody == null ? "null" : responseBody.string();
            return string;
        }
    }

    public static String perfanaMessageToJson(TestContext context, boolean completed, Map<String, String> extraVariables) {
        PerfanaMessage.PerfanaMessageBuilder perfanaMessageBuilder = PerfanaMessage.builder().testRunId(context.getTestRunId()).workload(context.getWorkload()).testEnvironment(context.getTestEnvironment()).systemUnderTest(context.getSystemUnderTest()).version(context.getVersion()).cibuildResultsUrl(context.getCIBuildResultsUrl()).rampUp(String.valueOf(context.getRampupTime().getSeconds())).duration(String.valueOf(context.getPlannedDuration().getSeconds())).completed(completed).annotations(context.getAnnotations()).tags(context.getTags());
        context.getVariables().forEach((k, v) -> perfanaMessageBuilder.variable(Variable.builder().placeholder((String)k).value((String)v).build()));
        extraVariables.forEach((k, v) -> perfanaMessageBuilder.variable(Variable.builder().placeholder((String)k).value((String)v).build()));
        PerfanaMessage perfanaMessage = perfanaMessageBuilder.build();
        try {
            return perfanaMessageWriter.writeValueAsString((Object)perfanaMessage);
        }
        catch (JsonProcessingException e) {
            throw new PerfanaClientRuntimeException("Failed to write PerfanaMessage to json: " + perfanaMessage, (Exception)((Object)e));
        }
    }

    private String perfanaEventToJson(TestContext context, String eventTitle, String eventDescription) {
        PerfanaEvent event = PerfanaEvent.builder().systemUnderTest(context.getSystemUnderTest()).testEnvironment(context.getTestEnvironment()).title(eventTitle).description(eventDescription).tag(context.getWorkload()).build();
        try {
            return perfanaEventWriter.writeValueAsString((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new PerfanaClientRuntimeException("Unable to transform PerfanaEvent to json", (Exception)((Object)e));
        }
    }

    private String callCheckAsserts() throws PerfanaClientException, PerfanaAssertResultsException {
        String endPoint;
        try {
            endPoint = String.join((CharSequence)"/", "/api", "benchmark-results", this.encodeForURL(this.context.getSystemUnderTest()), this.encodeForURL(this.context.getTestRunId()));
        }
        catch (UnsupportedEncodingException e) {
            throw new PerfanaClientException("cannot encode Perfana url.", e);
        }
        Request request = this.createRequest(endPoint);
        int maxRetryCount = this.settings.getRetryMaxCount();
        long sleepDurationMillis = this.settings.getRetryDuration().toMillis();
        int retryCount = 0;
        String assertions = null;
        boolean keepRetrying = true;
        boolean assertionsAvailable = false;
        boolean checksSpecified = false;
        while (keepRetrying && retryCount++ < maxRetryCount) {
            block27: {
                try (Response response = this.client.newCall(request).execute();){
                    int code = response.code();
                    String body = this.extractBodyAsString(response.body());
                    if (body != null && body.contains("<!DOCTYPE html>")) {
                        throw new PerfanaAssertResultsException(String.format("Got html instead of json response for [%s]: [%s]", endPoint, body));
                    }
                    this.logger.debug(String.format("Received response for [%s] with code [%d] and body [%s]", request, code, body));
                    if (code == 200) {
                        assertions = body;
                        assertionsAvailable = true;
                        checksSpecified = true;
                        keepRetrying = false;
                        break block27;
                    }
                    PerfanaErrorMessage perfanaErrorMessage = this.extractPerfanaErrorMessage(body);
                    if (code == 204) {
                        assertionsAvailable = true;
                        keepRetrying = false;
                        this.logger.info(String.format("No check can be done for [%s], due to: %s", this.context.getTestRunId(), perfanaErrorMessage.getMessage()));
                        break block27;
                    }
                    if (code == 202) {
                        this.logger.info(String.format("Trying to get test run check results at %s, attempt (%d/%d). Test run evaluation in progress ...", endPoint, retryCount, maxRetryCount));
                        break block27;
                    }
                    if (code == 503 || code == 502) {
                        this.logger.warn(String.format("Perfana is currently unavailable (%s) for [%s]. Will retry (%d/%d)...", code, this.context.getTestRunId(), retryCount, maxRetryCount));
                        break block27;
                    }
                    if (code == 400) {
                        String dueTo = this.extractDueTo(body);
                        throw new PerfanaAssertResultsException(String.format("Bad request from client (%d) to results for [%s].%s", code, this.context.getTestRunId(), dueTo));
                    }
                    if (code == 500) {
                        throw new PerfanaAssertResultsException(String.format("Test run [%s] has been marked as invalid, due to: %s", this.context.getTestRunId(), perfanaErrorMessage.getMessage()));
                    }
                    if (code == 404) {
                        throw new PerfanaAssertResultsException(String.format("Test run [%s] not found, due to: %s", this.context.getTestRunId(), perfanaErrorMessage.getMessage()));
                    }
                    if (code == 401) {
                        String dueTo = this.extractDueTo(response.header("WWW-Authenticate"));
                        throw new PerfanaAssertResultsException(String.format("Not authorized (%d) for [%s]. Check the Perfana API key.%s", code, endPoint, dueTo));
                    }
                    throw new PerfanaAssertResultsException(String.format("No action defined for dealing with http code (%d) for [%s]. Message: %s", code, endPoint, perfanaErrorMessage));
                }
                catch (IOException e) {
                    this.logger.warn(String.format("IO Exception while trying to get test run check results at [%s], will retry (%d/%d)...[%s][%s]", endPoint, retryCount, maxRetryCount, e.getClass().getName(), e.getMessage()));
                }
            }
            if (assertionsAvailable) continue;
            this.sleep(sleepDurationMillis);
        }
        if (!assertionsAvailable) {
            String message = "Failed to get test run check results at [" + endPoint + "], maximum attempts reached!";
            this.logger.warn(message);
            throw new PerfanaAssertResultsException(message);
        }
        return checksSpecified ? assertions : null;
    }

    @Nullable
    private String extractBodyAsString(ResponseBody responseBody) throws IOException {
        return responseBody == null ? null : responseBody.string();
    }

    @NotNull
    private String extractDueTo(String bodyAsString) {
        String dueTo = bodyAsString != null && !bodyAsString.isEmpty() ? " Due to : " + bodyAsString : "";
        return dueTo;
    }

    private PerfanaErrorMessage extractPerfanaErrorMessage(String messageBody) throws IOException {
        PerfanaErrorMessage perfanaErrorMessage;
        if (messageBody == null) {
            return PERFANA_ERROR_MESSAGE_NOT_FOUND;
        }
        try {
            perfanaErrorMessage = (PerfanaErrorMessage)errorMessageReader.readValue(messageBody);
        }
        catch (JsonProcessingException e) {
            this.logger.warn(String.format("Failed to process Perfana error message: [%s] due to: %s", new Object[]{messageBody, e}));
            return PERFANA_ERROR_MESSAGE_NOT_FOUND;
        }
        return perfanaErrorMessage;
    }

    private void sleep(long sleepDurationMillis) {
        try {
            Thread.sleep(sleepDurationMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private String encodeForURL(String testRunId) throws UnsupportedEncodingException {
        return URLEncoder.encode(testRunId, "UTF-8").replace("\\", "%20");
    }

    public String assertResults() throws PerfanaClientException, PerfanaAssertResultsException, PerfanaAssertionsAreFalse {
        Benchmark benchmark;
        if (!this.assertResultsEnabled) {
            String message = "Perfana assert results is not enabled and will not be checked.";
            this.logger.info(message);
            return message;
        }
        String assertions = this.callCheckAsserts();
        if (assertions == null) {
            return "No checks have been specified for this test run! Set assertResults property to false or create checks for key metrics";
        }
        try {
            benchmark = (Benchmark)perfanaBenchmarkReader.readValue(assertions);
        }
        catch (IOException e) {
            throw new PerfanaClientRuntimeException("Unable to parse benchmark message: " + assertions, e);
        }
        Optional<Result> baseline = Optional.ofNullable(benchmark.getBenchmarkBaselineTestRun());
        Optional<Result> previous = Optional.ofNullable(benchmark.getBenchmarkPreviousTestRun());
        Optional<Result> requirements = Optional.ofNullable(benchmark.getRequirements());
        requirements.ifPresent(r -> this.logger.info("Requirements: " + r.isResult()));
        baseline.ifPresent(r -> this.logger.info("Compared to baseline test run: " + r.isResult()));
        previous.ifPresent(r -> this.logger.info("Compared to previous test run: " + r.isResult()));
        StringBuilder text = new StringBuilder();
        if (assertions.contains("false")) {
            text.append("One or more Perfana assertions are failing: \n");
            requirements.filter(r -> !r.isResult()).ifPresent(r -> text.append("Requirements check failed: ").append(r.getDeeplink()).append("\n"));
            baseline.filter(r -> !r.isResult()).ifPresent(r -> text.append("Comparison check to baseline test run failed: ").append(r.getDeeplink()).append("\n"));
            previous.filter(r -> !r.isResult()).ifPresent(r -> text.append("Comparison check to previous test run failed: ").append(r.getDeeplink()).append("\n"));
            this.logger.info("Test run has failed checks: " + text);
            throw new PerfanaAssertionsAreFalse(text.toString());
        }
        text.append("All configured checks are OK: \n");
        requirements.ifPresent(r -> text.append(r.getDeeplink()).append("\n"));
        baseline.ifPresent(r -> text.append(r.getDeeplink()).append("\n"));
        previous.ifPresent(r -> text.append(r.getDeeplink()));
        return text.toString();
    }

    public String toString() {
        return "PerfanaClient [testRunId:" + this.context.getTestRunId() + " workload: " + this.context.getWorkload() + " testEnvironment: " + this.context.getTestEnvironment() + " Perfana url: " + this.settings.getPerfanaUrl() + "]";
    }

    public void addTestRunConfigKeyValue(TestRunConfigKeyValue testRunConfigKeyValue) {
        this.logger.info("add Perfana test-run-config with key-value: " + testRunConfigKeyValue);
        try {
            String json = testRunConfigKeyValueWriter.writeValueAsString((Object)testRunConfigKeyValue);
            String result = this.post("/api/config/key", json);
            this.logger.debug("result: " + result);
        }
        catch (JsonProcessingException e) {
            this.logger.error("failed to serialize " + testRunConfigKeyValue + " to json", e);
        }
        catch (IOException e) {
            this.logger.error("failed to call Perfana event endpoint: " + e.getMessage());
        }
    }

    public void addTestRunConfigJson(TestRunConfigJson testRunConfigJson) {
        this.logger.info("add Perfana test-run-config with json with " + testRunConfigJson.getJson().length() + " characters.");
        this.logger.debug("add Perfana test-run-config with json: " + testRunConfigJson);
        try {
            String json = testRunConfigJsonWriter.writeValueAsString((Object)testRunConfigJson);
            String result = this.post("/api/config/json", json);
            this.logger.debug("result: " + result);
        }
        catch (JsonProcessingException e) {
            this.logger.error("failed to serialize " + testRunConfigJson + " to json", e);
        }
        catch (IOException e) {
            this.logger.error("failed to call Perfana event endpoint: " + e.getMessage());
        }
    }

    public void addTestRunConfigKeys(TestRunConfigKeys testRunConfigKeys) {
        this.logger.info("add Perfana test-run-config with " + testRunConfigKeys.getConfigItems().size() + " keys");
        this.logger.debug("add Perfana test-run-config with keys: " + testRunConfigKeys);
        try {
            String keys = testRunConfigKeysWriter.writeValueAsString((Object)testRunConfigKeys);
            String result = this.post("/api/config/keys", keys);
            this.logger.debug("result: " + result);
        }
        catch (JsonProcessingException e) {
            this.logger.error("failed to serialize " + testRunConfigKeys + " to json", e);
        }
        catch (IOException e) {
            this.logger.error("failed to call Perfana event endpoint: " + e.getMessage());
        }
    }

    static {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        perfanaBenchmarkReader = objectMapper.reader().forType(Benchmark.class);
        errorMessageReader = objectMapper.reader().forType(PerfanaErrorMessage.class);
        perfanaTestReader = objectMapper.reader().forType(PerfanaTest.class);
        perfanaMessageWriter = objectMapper.writer().forType(PerfanaMessage.class);
        perfanaEventWriter = objectMapper.writer().forType(PerfanaEvent.class);
        testRunConfigKeyValueWriter = objectMapper.writer().forType(TestRunConfigKeyValue.class);
        testRunConfigJsonWriter = objectMapper.writer().forType(TestRunConfigJson.class);
        testRunConfigKeysWriter = objectMapper.writer().forType(TestRunConfigKeys.class);
    }
}

