/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.perfana.client.domain.Alert;
import io.perfana.client.domain.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PerfanaTest {
    @JsonProperty(value="_id")
    private final String id;
    private final String systemUnderTest;
    private final String testRunId;
    private final String version;
    private final String testEnvironment;
    private final String workload;
    @JsonProperty(value="CIBuildResultsUrl")
    private final String cibuildResultsUrl;
    private final int duration;
    private final int plannedDuration;
    private final int rampUp;
    private final String start;
    private final String end;
    private final String expires;
    private final boolean completed;
    private final boolean abort;
    private final String abortMessage;
    private final List<Alert> alerts;
    private final List<String> tags;
    private final List<Variable> variables;

    public static PerfanaTestBuilder builder() {
        return new PerfanaTestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getCibuildResultsUrl() {
        return this.cibuildResultsUrl;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getPlannedDuration() {
        return this.plannedDuration;
    }

    public int getRampUp() {
        return this.rampUp;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getExpires() {
        return this.expires;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public String getAbortMessage() {
        return this.abortMessage;
    }

    public List<Alert> getAlerts() {
        return this.alerts;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerfanaTest)) {
            return false;
        }
        PerfanaTest other = (PerfanaTest)o;
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getPlannedDuration() != other.getPlannedDuration()) {
            return false;
        }
        if (this.getRampUp() != other.getRampUp()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        if (this.isAbort() != other.isAbort()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$systemUnderTest = this.getSystemUnderTest();
        String other$systemUnderTest = other.getSystemUnderTest();
        if (this$systemUnderTest == null ? other$systemUnderTest != null : !this$systemUnderTest.equals(other$systemUnderTest)) {
            return false;
        }
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$workload = this.getWorkload();
        String other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !this$workload.equals(other$workload)) {
            return false;
        }
        String this$cibuildResultsUrl = this.getCibuildResultsUrl();
        String other$cibuildResultsUrl = other.getCibuildResultsUrl();
        if (this$cibuildResultsUrl == null ? other$cibuildResultsUrl != null : !this$cibuildResultsUrl.equals(other$cibuildResultsUrl)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        String this$end = this.getEnd();
        String other$end = other.getEnd();
        if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
            return false;
        }
        String this$expires = this.getExpires();
        String other$expires = other.getExpires();
        if (this$expires == null ? other$expires != null : !this$expires.equals(other$expires)) {
            return false;
        }
        String this$abortMessage = this.getAbortMessage();
        String other$abortMessage = other.getAbortMessage();
        if (this$abortMessage == null ? other$abortMessage != null : !this$abortMessage.equals(other$abortMessage)) {
            return false;
        }
        List<Alert> this$alerts = this.getAlerts();
        List<Alert> other$alerts = other.getAlerts();
        if (this$alerts == null ? other$alerts != null : !((Object)this$alerts).equals(other$alerts)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Variable> this$variables = this.getVariables();
        List<Variable> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getPlannedDuration();
        result = result * 59 + this.getRampUp();
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        result = result * 59 + (this.isAbort() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $systemUnderTest = this.getSystemUnderTest();
        result = result * 59 + ($systemUnderTest == null ? 43 : $systemUnderTest.hashCode());
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : $workload.hashCode());
        String $cibuildResultsUrl = this.getCibuildResultsUrl();
        result = result * 59 + ($cibuildResultsUrl == null ? 43 : $cibuildResultsUrl.hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        String $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        String $expires = this.getExpires();
        result = result * 59 + ($expires == null ? 43 : $expires.hashCode());
        String $abortMessage = this.getAbortMessage();
        result = result * 59 + ($abortMessage == null ? 43 : $abortMessage.hashCode());
        List<Alert> $alerts = this.getAlerts();
        result = result * 59 + ($alerts == null ? 43 : ((Object)$alerts).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Variable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    public String toString() {
        return "PerfanaTest(id=" + this.getId() + ", systemUnderTest=" + this.getSystemUnderTest() + ", testRunId=" + this.getTestRunId() + ", version=" + this.getVersion() + ", testEnvironment=" + this.getTestEnvironment() + ", workload=" + this.getWorkload() + ", cibuildResultsUrl=" + this.getCibuildResultsUrl() + ", duration=" + this.getDuration() + ", plannedDuration=" + this.getPlannedDuration() + ", rampUp=" + this.getRampUp() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", expires=" + this.getExpires() + ", completed=" + this.isCompleted() + ", abort=" + this.isAbort() + ", abortMessage=" + this.getAbortMessage() + ", alerts=" + this.getAlerts() + ", tags=" + this.getTags() + ", variables=" + this.getVariables() + ")";
    }

    private PerfanaTest() {
        this.id = null;
        this.systemUnderTest = null;
        this.testRunId = null;
        this.version = null;
        this.testEnvironment = null;
        this.workload = null;
        this.cibuildResultsUrl = null;
        this.duration = 0;
        this.plannedDuration = 0;
        this.rampUp = 0;
        this.start = null;
        this.end = null;
        this.expires = null;
        this.completed = false;
        this.abort = false;
        this.abortMessage = null;
        this.alerts = null;
        this.tags = null;
        this.variables = null;
    }

    public PerfanaTest(String id, String systemUnderTest, String testRunId, String version, String testEnvironment, String workload, String cibuildResultsUrl, int duration, int plannedDuration, int rampUp, String start, String end, String expires, boolean completed, boolean abort, String abortMessage, List<Alert> alerts, List<String> tags, List<Variable> variables) {
        this.id = id;
        this.systemUnderTest = systemUnderTest;
        this.testRunId = testRunId;
        this.version = version;
        this.testEnvironment = testEnvironment;
        this.workload = workload;
        this.cibuildResultsUrl = cibuildResultsUrl;
        this.duration = duration;
        this.plannedDuration = plannedDuration;
        this.rampUp = rampUp;
        this.start = start;
        this.end = end;
        this.expires = expires;
        this.completed = completed;
        this.abort = abort;
        this.abortMessage = abortMessage;
        this.alerts = alerts;
        this.tags = tags;
        this.variables = variables;
    }

    public static class PerfanaTestBuilder {
        private String id;
        private String systemUnderTest;
        private String testRunId;
        private String version;
        private String testEnvironment;
        private String workload;
        private String cibuildResultsUrl;
        private int duration;
        private int plannedDuration;
        private int rampUp;
        private String start;
        private String end;
        private String expires;
        private boolean completed;
        private boolean abort;
        private String abortMessage;
        private ArrayList<Alert> alerts;
        private ArrayList<String> tags;
        private ArrayList<Variable> variables;

        PerfanaTestBuilder() {
        }

        @JsonProperty(value="_id")
        public PerfanaTestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PerfanaTestBuilder systemUnderTest(String systemUnderTest) {
            this.systemUnderTest = systemUnderTest;
            return this;
        }

        public PerfanaTestBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public PerfanaTestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public PerfanaTestBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public PerfanaTestBuilder workload(String workload) {
            this.workload = workload;
            return this;
        }

        @JsonProperty(value="CIBuildResultsUrl")
        public PerfanaTestBuilder cibuildResultsUrl(String cibuildResultsUrl) {
            this.cibuildResultsUrl = cibuildResultsUrl;
            return this;
        }

        public PerfanaTestBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public PerfanaTestBuilder plannedDuration(int plannedDuration) {
            this.plannedDuration = plannedDuration;
            return this;
        }

        public PerfanaTestBuilder rampUp(int rampUp) {
            this.rampUp = rampUp;
            return this;
        }

        public PerfanaTestBuilder start(String start) {
            this.start = start;
            return this;
        }

        public PerfanaTestBuilder end(String end) {
            this.end = end;
            return this;
        }

        public PerfanaTestBuilder expires(String expires) {
            this.expires = expires;
            return this;
        }

        public PerfanaTestBuilder completed(boolean completed) {
            this.completed = completed;
            return this;
        }

        public PerfanaTestBuilder abort(boolean abort) {
            this.abort = abort;
            return this;
        }

        public PerfanaTestBuilder abortMessage(String abortMessage) {
            this.abortMessage = abortMessage;
            return this;
        }

        public PerfanaTestBuilder alert(Alert alert) {
            if (this.alerts == null) {
                this.alerts = new ArrayList();
            }
            this.alerts.add(alert);
            return this;
        }

        public PerfanaTestBuilder alerts(Collection<? extends Alert> alerts) {
            if (alerts == null) {
                throw new NullPointerException("alerts cannot be null");
            }
            if (this.alerts == null) {
                this.alerts = new ArrayList();
            }
            this.alerts.addAll(alerts);
            return this;
        }

        public PerfanaTestBuilder clearAlerts() {
            if (this.alerts != null) {
                this.alerts.clear();
            }
            return this;
        }

        public PerfanaTestBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public PerfanaTestBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public PerfanaTestBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public PerfanaTestBuilder variable(Variable variable) {
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.add(variable);
            return this;
        }

        public PerfanaTestBuilder variables(Collection<? extends Variable> variables) {
            if (variables == null) {
                throw new NullPointerException("variables cannot be null");
            }
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.addAll(variables);
            return this;
        }

        public PerfanaTestBuilder clearVariables() {
            if (this.variables != null) {
                this.variables.clear();
            }
            return this;
        }

        public PerfanaTest build() {
            List<Variable> variables;
            List<String> tags;
            List<Alert> alerts;
            switch (this.alerts == null ? 0 : this.alerts.size()) {
                case 0: {
                    alerts = Collections.emptyList();
                    break;
                }
                case 1: {
                    alerts = Collections.singletonList(this.alerts.get(0));
                    break;
                }
                default: {
                    alerts = Collections.unmodifiableList(new ArrayList<Alert>(this.alerts));
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            switch (this.variables == null ? 0 : this.variables.size()) {
                case 0: {
                    variables = Collections.emptyList();
                    break;
                }
                case 1: {
                    variables = Collections.singletonList(this.variables.get(0));
                    break;
                }
                default: {
                    variables = Collections.unmodifiableList(new ArrayList<Variable>(this.variables));
                }
            }
            return new PerfanaTest(this.id, this.systemUnderTest, this.testRunId, this.version, this.testEnvironment, this.workload, this.cibuildResultsUrl, this.duration, this.plannedDuration, this.rampUp, this.start, this.end, this.expires, this.completed, this.abort, this.abortMessage, alerts, tags, variables);
        }

        public String toString() {
            return "PerfanaTest.PerfanaTestBuilder(id=" + this.id + ", systemUnderTest=" + this.systemUnderTest + ", testRunId=" + this.testRunId + ", version=" + this.version + ", testEnvironment=" + this.testEnvironment + ", workload=" + this.workload + ", cibuildResultsUrl=" + this.cibuildResultsUrl + ", duration=" + this.duration + ", plannedDuration=" + this.plannedDuration + ", rampUp=" + this.rampUp + ", start=" + this.start + ", end=" + this.end + ", expires=" + this.expires + ", completed=" + this.completed + ", abort=" + this.abort + ", abortMessage=" + this.abortMessage + ", alerts=" + this.alerts + ", tags=" + this.tags + ", variables=" + this.variables + ")";
        }
    }
}

