/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.PerfanaClient;
import io.perfana.client.PerfanaClientBuilder;
import io.perfana.client.api.PerfanaConnectionSettings;
import io.perfana.client.api.PerfanaConnectionSettingsBuilder;
import io.perfana.client.api.TestContextBuilder;
import io.perfana.client.exception.PerfanaAssertionsAreFalse;
import io.perfana.client.exception.PerfanaClientException;
import io.perfana.client.exception.PerfanaClientRuntimeException;
import io.perfana.event.PerfanaClientEventLogger;
import io.perfana.event.PerfanaEventContext;
import io.perfana.eventscheduler.api.CustomEvent;
import io.perfana.eventscheduler.api.EventAdapter;
import io.perfana.eventscheduler.api.EventCheck;
import io.perfana.eventscheduler.api.EventLogger;
import io.perfana.eventscheduler.api.EventStatus;
import io.perfana.eventscheduler.api.config.EventContext;
import io.perfana.eventscheduler.api.config.TestContext;
import io.perfana.eventscheduler.api.message.EventMessageBus;
import io.perfana.eventscheduler.api.message.EventMessageReceiver;
import io.perfana.eventscheduler.exception.handler.KillSwitchException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerfanaEvent
extends EventAdapter<PerfanaEventContext> {
    private final String CLASSNAME = PerfanaEvent.class.getName();
    private final String eventName;
    private final io.perfana.client.api.TestContext perfanaTestContext;
    private final EventMessageBus messageBus;
    private final Map<String, String> receivedVariables = new ConcurrentHashMap<String, String>();
    private final PerfanaClient perfanaClient;
    private String abortDetailMessage = null;
    private EventCheck eventCheck;

    PerfanaEvent(PerfanaEventContext context, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)context, messageBus, logger);
        this.eventCheck = new EventCheck(context.getName(), this.CLASSNAME, EventStatus.UNKNOWN, "No known result yet. Try again some time later.");
        this.eventName = context.getName();
        this.perfanaTestContext = PerfanaEvent.createPerfanaTestContext(context);
        this.messageBus = messageBus;
        this.perfanaClient = PerfanaEvent.createPerfanaClient(context, this.perfanaTestContext, logger);
        EventMessageReceiver eventMessageReceiver = m -> {
            if (!m.getVariables().isEmpty()) {
                logger.info("received variables from " + m.getPluginName() + ": " + m.getVariables());
                this.receivedVariables.putAll(m.getVariables());
            }
        };
        this.messageBus.addReceiver(eventMessageReceiver);
    }

    private static PerfanaClient createPerfanaClient(PerfanaEventContext eventContext, io.perfana.client.api.TestContext perfanaTestContext, EventLogger logger) {
        PerfanaConnectionSettings settings = new PerfanaConnectionSettingsBuilder().setPerfanaUrl(eventContext.getPerfanaUrl()).setApiKey(eventContext.getApiKey()).build();
        PerfanaClientBuilder builder = new PerfanaClientBuilder().setLogger(new PerfanaClientEventLogger(logger)).setTestContext(perfanaTestContext).setPerfanaConnectionSettings(settings).setAssertResultsEnabled(eventContext.isAssertResultsEnabled());
        return builder.build();
    }

    public void startTest() {
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test start", "Test run started");
    }

    public void afterTest() {
        if (this.abortDetailMessage != null) {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test abort", this.abortDetailMessage);
        } else {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test end", "Test run completed");
        }
        this.finalizePerfanaTestRun();
    }

    private void finalizePerfanaTestRun() {
        this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, true, this.receivedVariables);
        this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.SUCCESS, "All ok!");
        try {
            String text = this.perfanaClient.assertResults();
            this.logger.info("Received Perfana check results: " + text);
        }
        catch (PerfanaClientException e) {
            this.logger.error("Perfana checks failed.", (Throwable)e);
            this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.FAILURE, "Failed to get check results: " + e.getMessage());
        }
        catch (PerfanaAssertionsAreFalse perfanaAssertionsAreFalse) {
            this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.FAILURE, perfanaAssertionsAreFalse.getMessage());
        }
    }

    public void abortTest() {
        String eventTitle = "Test aborted";
        String eventDescription = this.abortDetailMessage == null ? "manually aborted" : this.abortDetailMessage;
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, eventTitle, eventDescription);
        this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.ABORTED, eventDescription);
        this.finalizePerfanaTestRun();
    }

    public EventCheck check() {
        return this.eventCheck;
    }

    public void keepAlive() {
        this.logger.debug("Keep alive called");
        try {
            this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, false, this.receivedVariables);
        }
        catch (KillSwitchException killSwitchException) {
            this.abortDetailMessage = killSwitchException.getMessage();
            throw killSwitchException;
        }
    }

    public void customEvent(CustomEvent customEvent) {
        try {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, customEvent.getName(), customEvent.getDescription());
        }
        catch (Exception e) {
            this.logger.error("Perfana call event failed", (Throwable)e);
        }
    }

    private static io.perfana.client.api.TestContext createPerfanaTestContext(PerfanaEventContext context) {
        TestContext testContext = context.getTestContext();
        if (testContext == null) {
            throw new PerfanaClientRuntimeException("testConfig in eventConfig is null: " + (Object)((Object)context));
        }
        return new TestContextBuilder().setVariables(context.getVariables()).setTags(testContext.getTags()).setAnnotations(testContext.getAnnotations()).setSystemUnderTest(testContext.getSystemUnderTest()).setVersion(testContext.getVersion()).setCIBuildResultsUrl(testContext.getBuildResultsUrl()).setConstantLoadTime(testContext.getConstantLoadTime()).setRampupTime(testContext.getRampupTime()).setTestEnvironment(testContext.getTestEnvironment()).setTestRunId(testContext.getTestRunId()).setWorkload(testContext.getWorkload()).build();
    }
}

