/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PerfanaEvent {
    private final String systemUnderTest;
    private final String testEnvironment;
    private final String title;
    private final String description;
    private final List<String> tags;

    public static PerfanaEventBuilder builder() {
        return new PerfanaEventBuilder();
    }

    public String getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerfanaEvent)) {
            return false;
        }
        PerfanaEvent other = (PerfanaEvent)o;
        String this$systemUnderTest = this.getSystemUnderTest();
        String other$systemUnderTest = other.getSystemUnderTest();
        if (this$systemUnderTest == null ? other$systemUnderTest != null : !this$systemUnderTest.equals(other$systemUnderTest)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $systemUnderTest = this.getSystemUnderTest();
        result = result * 59 + ($systemUnderTest == null ? 43 : $systemUnderTest.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "PerfanaEvent(systemUnderTest=" + this.getSystemUnderTest() + ", testEnvironment=" + this.getTestEnvironment() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    private PerfanaEvent() {
        this.systemUnderTest = null;
        this.testEnvironment = null;
        this.title = null;
        this.description = null;
        this.tags = null;
    }

    public PerfanaEvent(String systemUnderTest, String testEnvironment, String title, String description, List<String> tags) {
        this.systemUnderTest = systemUnderTest;
        this.testEnvironment = testEnvironment;
        this.title = title;
        this.description = description;
        this.tags = tags;
    }

    public static class PerfanaEventBuilder {
        private String systemUnderTest;
        private String testEnvironment;
        private String title;
        private String description;
        private ArrayList<String> tags;

        PerfanaEventBuilder() {
        }

        public PerfanaEventBuilder systemUnderTest(String systemUnderTest) {
            this.systemUnderTest = systemUnderTest;
            return this;
        }

        public PerfanaEventBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public PerfanaEventBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PerfanaEventBuilder description(String description) {
            this.description = description;
            return this;
        }

        public PerfanaEventBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public PerfanaEventBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public PerfanaEventBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public PerfanaEvent build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new PerfanaEvent(this.systemUnderTest, this.testEnvironment, this.title, this.description, tags);
        }

        public String toString() {
            return "PerfanaEvent.PerfanaEventBuilder(systemUnderTest=" + this.systemUnderTest + ", testEnvironment=" + this.testEnvironment + ", title=" + this.title + ", description=" + this.description + ", tags=" + this.tags + ")";
        }
    }
}

