/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.PerfanaClient;
import io.perfana.client.PerfanaClientBuilder;
import io.perfana.client.api.PerfanaConnectionSettings;
import io.perfana.client.api.PerfanaConnectionSettingsBuilder;
import io.perfana.client.api.TestContext;
import io.perfana.client.api.TestContextBuilder;
import io.perfana.client.exception.PerfanaAssertionsAreFalse;
import io.perfana.client.exception.PerfanaClientException;
import io.perfana.event.PerfanaClientEventLogger;
import java.util.Collection;
import java.util.Set;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.EventStatus;
import nl.stokpop.eventscheduler.exception.handler.KillSwitchException;

public class PerfanaEvent
extends EventAdapter {
    private final String CLASSNAME = PerfanaEvent.class.getName();
    private static final Set<String> ALLOWED_PROPERTIES = PerfanaEvent.setOf((String[])new String[]{"perfanaUrl"});
    private PerfanaClient perfanaClient;
    private TestContext perfanaTestContext;
    private String abortDetailMessage = null;
    private EventCheck eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.UNKNOWN, "No known result yet. Try again some time later.");

    PerfanaEvent(String name, nl.stokpop.eventscheduler.api.TestContext context, EventProperties properties, EventLogger logger) {
        super(name, context, properties, logger);
        this.perfanaTestContext = PerfanaEvent.createPerfanaTestContext(context);
    }

    public Collection<String> allowedProperties() {
        return ALLOWED_PROPERTIES;
    }

    public void beforeTest() {
        PerfanaConnectionSettings settings = new PerfanaConnectionSettingsBuilder().setPerfanaUrl(this.eventProperties.getPropertyOrDefault("perfanaUrl", "http://localhost:8888")).build();
        PerfanaClientBuilder builder = new PerfanaClientBuilder().setLogger(new PerfanaClientEventLogger(this.logger)).setTestContext(this.perfanaTestContext).setPerfanaConnectionSettings(settings).setAssertResultsEnabled(Boolean.parseBoolean(this.eventProperties.getPropertyOrDefault("assertResultsEnabled", "true")));
        this.perfanaClient = builder.build();
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test start", "Test run started");
    }

    public void afterTest() {
        if (this.abortDetailMessage != null) {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test abort", this.abortDetailMessage);
        } else {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, "Test end", "Test run completed");
        }
        this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, true);
        this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.SUCCESS, "All ok!");
        try {
            String text = this.perfanaClient.assertResults();
            this.logger.info("Received Perfana check results: " + text);
        }
        catch (PerfanaClientException e) {
            this.logger.error("Perfana checks failed.", (Throwable)e);
            this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.FAILURE, "Failed to get check results: " + e.getMessage());
        }
        catch (PerfanaAssertionsAreFalse perfanaAssertionsAreFalse) {
            this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.FAILURE, perfanaAssertionsAreFalse.getMessage());
        }
    }

    public void abortTest() {
        String eventTitle = "Test aborted";
        String eventDescription = this.abortDetailMessage == null ? "manually aborted" : this.abortDetailMessage;
        this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, eventTitle, eventDescription);
        this.eventCheck = new EventCheck(this.eventName, this.CLASSNAME, EventStatus.ABORTED, eventDescription);
    }

    public EventCheck check() {
        return this.eventCheck;
    }

    public void keepAlive() {
        this.logger.debug("Keep alive called");
        try {
            this.perfanaClient.callPerfanaTestEndpoint(this.perfanaTestContext, false);
        }
        catch (KillSwitchException killSwitchException) {
            this.abortDetailMessage = killSwitchException.getMessage();
            throw killSwitchException;
        }
    }

    public void customEvent(CustomEvent customEvent) {
        try {
            this.perfanaClient.callPerfanaEvent(this.perfanaTestContext, customEvent.getName(), customEvent.getDescription());
        }
        catch (Exception e) {
            this.logger.error("Perfana call event failed", (Throwable)e);
        }
    }

    private static TestContext createPerfanaTestContext(nl.stokpop.eventscheduler.api.TestContext testContext) {
        return new TestContextBuilder().setVariables(testContext.getVariables()).setTags(testContext.getTags()).setAnnotations(testContext.getAnnotations()).setSystemUnderTest(testContext.getSystemUnderTest()).setVersion(testContext.getVersion()).setCIBuildResultsUrl(testContext.getCIBuildResultsUrl()).setConstantLoadTime(testContext.getPlannedDuration()).setRampupTime(testContext.getRampupTime()).setTestEnvironment(testContext.getTestEnvironment()).setTestRunId(testContext.getTestRunId()).setWorkload(testContext.getWorkload()).build();
    }
}

