/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.perfana.client.domain.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PerfanaMessage {
    private final String testRunId;
    private final String workload;
    private final String testEnvironment;
    private final String systemUnderTest;
    private final String version;
    @JsonProperty(value="CIBuildResultsUrl")
    private final String cibuildResultsUrl;
    private final String rampUp;
    private final String duration;
    private final boolean completed;
    private final String annotations;
    private final List<String> tags;
    private final List<Variable> variables;

    public static PerfanaMessageBuilder builder() {
        return new PerfanaMessageBuilder();
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getTestEnvironment() {
        return this.testEnvironment;
    }

    public String getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCibuildResultsUrl() {
        return this.cibuildResultsUrl;
    }

    public String getRampUp() {
        return this.rampUp;
    }

    public String getDuration() {
        return this.duration;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerfanaMessage)) {
            return false;
        }
        PerfanaMessage other = (PerfanaMessage)o;
        String this$testRunId = this.getTestRunId();
        String other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !this$testRunId.equals(other$testRunId)) {
            return false;
        }
        String this$workload = this.getWorkload();
        String other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !this$workload.equals(other$workload)) {
            return false;
        }
        String this$testEnvironment = this.getTestEnvironment();
        String other$testEnvironment = other.getTestEnvironment();
        if (this$testEnvironment == null ? other$testEnvironment != null : !this$testEnvironment.equals(other$testEnvironment)) {
            return false;
        }
        String this$systemUnderTest = this.getSystemUnderTest();
        String other$systemUnderTest = other.getSystemUnderTest();
        if (this$systemUnderTest == null ? other$systemUnderTest != null : !this$systemUnderTest.equals(other$systemUnderTest)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$cibuildResultsUrl = this.getCibuildResultsUrl();
        String other$cibuildResultsUrl = other.getCibuildResultsUrl();
        if (this$cibuildResultsUrl == null ? other$cibuildResultsUrl != null : !this$cibuildResultsUrl.equals(other$cibuildResultsUrl)) {
            return false;
        }
        String this$rampUp = this.getRampUp();
        String other$rampUp = other.getRampUp();
        if (this$rampUp == null ? other$rampUp != null : !this$rampUp.equals(other$rampUp)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        String this$annotations = this.getAnnotations();
        String other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Variable> this$variables = this.getVariables();
        List<Variable> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : $testRunId.hashCode());
        String $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : $workload.hashCode());
        String $testEnvironment = this.getTestEnvironment();
        result = result * 59 + ($testEnvironment == null ? 43 : $testEnvironment.hashCode());
        String $systemUnderTest = this.getSystemUnderTest();
        result = result * 59 + ($systemUnderTest == null ? 43 : $systemUnderTest.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $cibuildResultsUrl = this.getCibuildResultsUrl();
        result = result * 59 + ($cibuildResultsUrl == null ? 43 : $cibuildResultsUrl.hashCode());
        String $rampUp = this.getRampUp();
        result = result * 59 + ($rampUp == null ? 43 : $rampUp.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        String $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : $annotations.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Variable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    public String toString() {
        return "PerfanaMessage(testRunId=" + this.getTestRunId() + ", workload=" + this.getWorkload() + ", testEnvironment=" + this.getTestEnvironment() + ", systemUnderTest=" + this.getSystemUnderTest() + ", version=" + this.getVersion() + ", cibuildResultsUrl=" + this.getCibuildResultsUrl() + ", rampUp=" + this.getRampUp() + ", duration=" + this.getDuration() + ", completed=" + this.isCompleted() + ", annotations=" + this.getAnnotations() + ", tags=" + this.getTags() + ", variables=" + this.getVariables() + ")";
    }

    private PerfanaMessage() {
        this.testRunId = null;
        this.workload = null;
        this.testEnvironment = null;
        this.systemUnderTest = null;
        this.version = null;
        this.cibuildResultsUrl = null;
        this.rampUp = null;
        this.duration = null;
        this.completed = false;
        this.annotations = null;
        this.tags = null;
        this.variables = null;
    }

    public PerfanaMessage(String testRunId, String workload, String testEnvironment, String systemUnderTest, String version, String cibuildResultsUrl, String rampUp, String duration, boolean completed, String annotations, List<String> tags, List<Variable> variables) {
        this.testRunId = testRunId;
        this.workload = workload;
        this.testEnvironment = testEnvironment;
        this.systemUnderTest = systemUnderTest;
        this.version = version;
        this.cibuildResultsUrl = cibuildResultsUrl;
        this.rampUp = rampUp;
        this.duration = duration;
        this.completed = completed;
        this.annotations = annotations;
        this.tags = tags;
        this.variables = variables;
    }

    public static class PerfanaMessageBuilder {
        private String testRunId;
        private String workload;
        private String testEnvironment;
        private String systemUnderTest;
        private String version;
        private String cibuildResultsUrl;
        private String rampUp;
        private String duration;
        private boolean completed;
        private String annotations;
        private ArrayList<String> tags;
        private ArrayList<Variable> variables;

        PerfanaMessageBuilder() {
        }

        public PerfanaMessageBuilder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public PerfanaMessageBuilder workload(String workload) {
            this.workload = workload;
            return this;
        }

        public PerfanaMessageBuilder testEnvironment(String testEnvironment) {
            this.testEnvironment = testEnvironment;
            return this;
        }

        public PerfanaMessageBuilder systemUnderTest(String systemUnderTest) {
            this.systemUnderTest = systemUnderTest;
            return this;
        }

        public PerfanaMessageBuilder version(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="CIBuildResultsUrl")
        public PerfanaMessageBuilder cibuildResultsUrl(String cibuildResultsUrl) {
            this.cibuildResultsUrl = cibuildResultsUrl;
            return this;
        }

        public PerfanaMessageBuilder rampUp(String rampUp) {
            this.rampUp = rampUp;
            return this;
        }

        public PerfanaMessageBuilder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public PerfanaMessageBuilder completed(boolean completed) {
            this.completed = completed;
            return this;
        }

        public PerfanaMessageBuilder annotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        public PerfanaMessageBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public PerfanaMessageBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public PerfanaMessageBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public PerfanaMessageBuilder variable(Variable variable) {
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.add(variable);
            return this;
        }

        public PerfanaMessageBuilder variables(Collection<? extends Variable> variables) {
            if (variables == null) {
                throw new NullPointerException("variables cannot be null");
            }
            if (this.variables == null) {
                this.variables = new ArrayList();
            }
            this.variables.addAll(variables);
            return this;
        }

        public PerfanaMessageBuilder clearVariables() {
            if (this.variables != null) {
                this.variables.clear();
            }
            return this;
        }

        public PerfanaMessage build() {
            List<Variable> variables;
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            switch (this.variables == null ? 0 : this.variables.size()) {
                case 0: {
                    variables = Collections.emptyList();
                    break;
                }
                case 1: {
                    variables = Collections.singletonList(this.variables.get(0));
                    break;
                }
                default: {
                    variables = Collections.unmodifiableList(new ArrayList<Variable>(this.variables));
                }
            }
            return new PerfanaMessage(this.testRunId, this.workload, this.testEnvironment, this.systemUnderTest, this.version, this.cibuildResultsUrl, this.rampUp, this.duration, this.completed, this.annotations, tags, variables);
        }

        public String toString() {
            return "PerfanaMessage.PerfanaMessageBuilder(testRunId=" + this.testRunId + ", workload=" + this.workload + ", testEnvironment=" + this.testEnvironment + ", systemUnderTest=" + this.systemUnderTest + ", version=" + this.version + ", cibuildResultsUrl=" + this.cibuildResultsUrl + ", rampUp=" + this.rampUp + ", duration=" + this.duration + ", completed=" + this.completed + ", annotations=" + this.annotations + ", tags=" + this.tags + ", variables=" + this.variables + ")";
        }
    }
}

