/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.client.api;

import io.perfana.client.PerfanaUtils;
import io.perfana.client.api.PerfanaConnectionSettings;
import java.time.Duration;

public class PerfanaConnectionSettingsBuilder {
    private static final int DEFAULT_RETRY_TIME_SECONDS = 10;
    private static final int DEFAULT_RETRY_MAX_COUNT = 30;
    private String perfanaUrl = "unknown";
    private int retryMaxCount = 30;
    private Duration retryDuration = Duration.ofSeconds(10L);

    public PerfanaConnectionSettingsBuilder setRetryMaxCount(String retryMaxCount) {
        this.retryMaxCount = PerfanaUtils.parseInt("retryMaxCount", retryMaxCount, 30);
        return this;
    }

    public PerfanaConnectionSettingsBuilder setRetryTimeInSeconds(String retryTimeInSeconds) {
        this.retryDuration = Duration.ofSeconds(PerfanaUtils.parseInt("retryTimeInSeconds", retryTimeInSeconds, 10));
        return this;
    }

    public PerfanaConnectionSettingsBuilder setRetryMaxCount(int retryMaxCount) {
        this.retryMaxCount = retryMaxCount;
        return this;
    }

    public PerfanaConnectionSettingsBuilder setRetryDuration(Duration retryDuration) {
        if (retryDuration != null) {
            this.retryDuration = retryDuration;
        }
        return this;
    }

    public PerfanaConnectionSettingsBuilder setPerfanaUrl(String perfanaUrl) {
        if (PerfanaUtils.hasValue(perfanaUrl)) {
            this.perfanaUrl = perfanaUrl;
        }
        return this;
    }

    public PerfanaConnectionSettings build() {
        return new PerfanaConnectionSettings(this.retryMaxCount, this.retryDuration, this.perfanaUrl);
    }
}

