/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.api.PerfanaClientLogger;
import io.perfana.client.api.TestContext;
import io.perfana.event.PerfanaEvent;
import io.perfana.event.PerfanaEventBroadcaster;
import io.perfana.event.PerfanaEventProperties;
import io.perfana.event.ScheduleEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class PerfanaEventProvider
implements PerfanaEventBroadcaster {
    private final PerfanaClientLogger logger;
    private final List<PerfanaEvent> perfanaEvents;

    PerfanaEventProvider(List<PerfanaEvent> perfanaEvents, PerfanaClientLogger logger) {
        this.perfanaEvents = Collections.unmodifiableList(new ArrayList<PerfanaEvent>(perfanaEvents));
        this.logger = logger;
    }

    public static PerfanaEventProvider createInstanceWithEventsFromClasspath(PerfanaClientLogger logger) {
        return PerfanaEventProvider.createInstanceWithEventsFromClasspath(logger, null);
    }

    public static PerfanaEventProvider createInstanceWithEventsFromClasspath(PerfanaClientLogger logger, ClassLoader classLoader) {
        ServiceLoader<PerfanaEvent> perfanaEventLoader = classLoader == null ? ServiceLoader.load(PerfanaEvent.class) : ServiceLoader.load(PerfanaEvent.class, classLoader);
        ArrayList<PerfanaEvent> events = new ArrayList<PerfanaEvent>();
        for (PerfanaEvent event : perfanaEventLoader) {
            events.add(event);
        }
        return new PerfanaEventProvider(events, logger);
    }

    @Override
    public void broadcastBeforeTest(TestContext context, PerfanaEventProperties properties) {
        this.logger.info("broadcast before test event");
        this.perfanaEvents.forEach(this.catchExceptionWrapper(event -> event.beforeTest(context, properties.get((PerfanaEvent)event))));
    }

    @Override
    public void broadcastAfterTest(TestContext context, PerfanaEventProperties properties) {
        this.logger.info("broadcast after test event");
        this.perfanaEvents.forEach(this.catchExceptionWrapper(event -> event.afterTest(context, properties.get((PerfanaEvent)event))));
    }

    @Override
    public void broadCastKeepAlive(TestContext context, PerfanaEventProperties properties) {
        this.logger.debug("broadcast keep alive event");
        this.perfanaEvents.forEach(this.catchExceptionWrapper(event -> event.keepAlive(context, properties.get((PerfanaEvent)event))));
    }

    @Override
    public void broadcastCustomEvent(TestContext context, PerfanaEventProperties properties, ScheduleEvent scheduleEvent) {
        this.logger.info("broadcast " + scheduleEvent.getName() + " custom event");
        this.perfanaEvents.forEach(this.catchExceptionWrapper(event -> event.customEvent(context, properties.get((PerfanaEvent)event), scheduleEvent)));
    }

    private Consumer<PerfanaEvent> catchExceptionWrapper(Consumer<PerfanaEvent> consumer) {
        return event -> {
            try {
                consumer.accept((PerfanaEvent)event);
            }
            catch (Exception e) {
                String message = String.format("exception in perfana event (%s)", event.getName());
                if (this.logger != null) {
                    this.logger.error(message, e);
                }
                System.out.println("(note: better provide a logger): " + message);
            }
        };
    }
}

