/*
 * Decompiled with CFR 0.152.
 */
package io.perfana.event;

import io.perfana.client.exception.PerfanaClientRuntimeException;
import io.perfana.event.EventProperties;
import io.perfana.event.PerfanaEvent;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerfanaEventProperties {
    private Map<String, Map<String, String>> eventProperties = new ConcurrentHashMap<String, Map<String, String>>();

    public EventProperties get(PerfanaEvent event) {
        String canonicalName = PerfanaEventProperties.determineCanonicalName(event);
        Map<String, String> props = this.eventProperties.getOrDefault(canonicalName, Collections.emptyMap());
        return new EventProperties(props);
    }

    private static String determineCanonicalName(PerfanaEvent event) {
        String canonicalName = event.getClass().getCanonicalName();
        if (canonicalName == null) {
            String msg = String.format("Anonymous classes are not allowed for PerfanaEvent, sorry. [%s]", event.getClass());
            throw new PerfanaClientRuntimeException(msg);
        }
        return canonicalName;
    }

    public PerfanaEventProperties put(PerfanaEvent event, String name, String value) {
        String classImplName = PerfanaEventProperties.determineCanonicalName(event);
        this.put(classImplName, name, value);
        return this;
    }

    public PerfanaEventProperties put(String eventClassImplName, String name, String value) {
        this.eventProperties.computeIfAbsent(eventClassImplName, k -> new ConcurrentHashMap()).put(name, value);
        return this;
    }
}

